
#include <Complex.h>

#include "fxt.h"
#include "fxtaux.h"


#define FFT(re,im,ldn,is)  fht_fft(re,im,ldn,is)


void 
complex_fft(Complex *c, ulong ldn, int is)
//
// FFT wrapper to use the routines that use the data 
// in the real/imag form for type complex data 
//
{
    const ulong n=(1<<ldn);

    double *fr, *fi;
    fr=(double *)c;
    fi=fr+n;

    complex_to_real_imag(c,n);

    FFT(fr,fi,ldn,is);

    real_imag_to_complex(fr,fi,n);
}
//=========================== end COMPLEX_FFT ==========================


void 
real_imag_fft(double *fr, double *fi, ulong ldn, int is)
//
// FFT wrapper to use the routines that use the data 
// in the complex form for data in real/imag form
//
// data MUST lie in contiguous memory 
//
{
    const ulong n=(1<<ldn);
    const ulong n2=2*n;

    Complex *c;
    c=(Complex *)fr;

    real_imag_to_complex(fr,fi,n2);

//  _here_goes_YOUR_:
    complex_fft(c,ldn,is);

    complex_to_real_imag(c,n2);
}
//=========================== end REAL_IMAG_FFT ==========================
