
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"

void
fft_correlation0(double *f, double *g, ulong ldn)
//
// result in g
// 
{
    assert( f!=g );

    const ulong n=(1<<ldn);
    const ulong nh=(n>>1);  

    wrap_real_complex_fft0(f,ldn);
    wrap_real_complex_fft0(g,ldn);

    g[0] *=f[0];
    g[nh]*=f[nh];

    for(ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        cmult4(f[i],-f[j],g[i],g[j]);
    }

    wrap_complex_real_fft(g,ldn);

    d_multiply(g,n,1.0/n);
}
//============================= end FFT_CORRELATION0 =======================


void
fft_auto_correlation0(double *f, ulong ldn)
{
    const ulong n=(1<<ldn);
    const ulong nh=(n>>1);
    const double dn=1.0/n;

    wrap_real_complex_fft0(f,ldn);

    f[0] *=f[0];
    f[nh]*=f[nh];

    for(ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        f[i]=(f[i]*f[i]+f[j]*f[j])*dn;
        f[j]=0.0;
    }

    wrap_complex_real_fft(f,ldn);
}
//================ end FFT_AUTO_CORRELATION0 =================
