#include <math.h>

#include "fxtaux.h"


// define to use trig recurrence:
// (and possibly lose some precision, see below)
//#define TRIG_REC
// causes big speed loss on my machine !

// define to see the (maximum) error in trig recursion:
//#define TEST_REC

// define type to use in trig recursion:
// no precision loss with 'long double'
#define  TFLOAT  long double


#if defined TEST_REC
#include <iostream.h>
#endif


void
fht(double *fr, ulong ldn)
{
    if(ldn<=1)
    {
        if(ldn==1)  sumdiff2(fr[0],fr[1]);  // two point fht
        return;
    }

    double *fi,*fn,*gi;

    ulong n=(1<<ldn);

    scramble(fr,n);

    ulong k=ldn&1;

    if (k==0)    /* ldn is multiple of 2  => n is a power of 4 */
    {
        for (fi=fr,fn=fr+n;fi<fn;fi+=4)
        {
            double f0,f1,f2,f3;

            sumdiff4(fi[0],fi[1],f0,f1);
            sumdiff4(fi[2],fi[3],f2,f3);

            sumdiff4(f0,f2,fi[0],fi[2]);
            sumdiff4(f1,f3,fi[1],fi[3]);
        }
    }
    else          /* k==1,  ldn is no multiple of 2  => n is no power of 4 */
    {
        for (fi=fr,fn=fr+n,gi=fi+1;fi<fn;fi+=8,gi+=8)
        {
            double s1,c1,s2,c2,g0,f0,f1,g1;

            sumdiff4(fi[0],gi[0],s1,c1);
            sumdiff4(fi[2],gi[2],s2,c2);

            sumdiff4(s1,s2,f0,f1);
            sumdiff4(c1,c2,g0,g1);

            sumdiff4(fi[4],gi[4],s1,c1);
            sumdiff4(fi[6],gi[6],s2,c2);

            sumdiff2(s1,s2);

            c1 *= SQRT2;
            c2 *= SQRT2;

            sumdiff4(f0,s1,fi[0],fi[4]);
            sumdiff4(f1,s2,fi[2],fi[6]);
		    	
            sumdiff4(g0,c1,gi[0],gi[4]);
            sumdiff4(g1,c2,gi[2],gi[6]);
        }
    }

    if (n<16)  return;

    ulong k4;

    do
    {
	ulong k1,k2,k3,kx;

        k  += 2;
        k1  = 1  << k;
        k2  = k1 << 1;
        k4  = k2 << 1;
        k3  = k2 + k1;
        kx  = k1 >> 1;
        fi  = fr;
        gi  = fi + kx;
        fn  = fr + n;

        do
        {
            double f0,f1,f2,f3;

            sumdiff4(fi[0],fi[k1],f0,f1);
            sumdiff4(fi[k2],fi[k3],f2,f3);

            sumdiff4(f0,f2,fi[0],fi[k2]);
            sumdiff4(f1,f3,fi[k1],fi[k3]);

            sumdiff4(gi[0],gi[k1],f0,f1);
            f3      = SQRT2  * gi[k3];
            f2      = SQRT2  * gi[k2];

            sumdiff4(f0,f2,gi[0],gi[k2]);
            sumdiff4(f1,f3,gi[k1],gi[k3]);

            gi     += k4;
            fi     += k4;
        }
        while (fi<fn);


	double tt=M_PI/4/kx;

#if defined TRIG_REC
	TFLOAT s1,c1;
        TFLOAT al=sin(0.5*tt);
        al *= (2.0*al);
        TFLOAT be=sin(tt);
        s1=0.0;
        c1=1.0;
#if defined TEST_REC
        double dcm=0, dsm=0;
        double cm=0, sm=0;
#endif
#else
	double s1,c1;
#endif // defined TRIG_REC


        for(ulong i=1; i<kx; i++)
        {

#if defined TRIG_REC
	    TFLOAT c2,s2;
            c1-=(al*(tt=c1)+be*s1);
            s1-=(al*s1-be*tt);
#if defined TEST_REC
            s2=sin(M_PI/4*i/kx);
            c2=cos(M_PI/4*i/kx);
            c2-=c1; s2-=s1;

            if(fabs(c2)>dcm) {dcm=fabs(c2); cm=c2/c1;}
            if(fabs(s2)>dsm) {dsm=fabs(s2); sm=s2/s1;}
#endif
#else
            sincos(&c1,&s1,tt*i);
	    double c2,s2;

#endif // defined TRIG_REC

            csqr4(c1,s1,c2,s2);

            fn = fr +n;
            fi = fr +i;
            gi = fr +k1 -i;

            do
            {
	        double a,b,g0,f0,f1,g1,f2,g2,f3,g3;

                cmult6(s2,c2,fi[k1],gi[k1],b,a);
                sumdiff4(fi[0],a,f0,f1);
                sumdiff4(gi[0],b,g0,g1);

                cmult6(s2,c2,fi[k3],gi[k3],b,a);
                sumdiff4(fi[k2],a,f2,f3);
                sumdiff4(gi[k2],b,g2,g3);

                cmult6(s1,c1,f2,g3,b,a);
                sumdiff4(f0,a,fi[0],fi[k2]);
                sumdiff4(g1,b,gi[k1],gi[k3]);

                cmult6(c1,s1,g2,f3,b,a);
                sumdiff4(g0,a,gi[0],gi[k2]);
                sumdiff4(f1,b,fi[k1],fi[k3]);

                gi     += k4;
                fi     += k4;
            }
            while (fi<fn);

        }

#if defined TRIG_REC
#if defined TEST_REC
        cout << " i=" << i
             << ":  dcmax=" << dcm
             << "    rel.err=" << cm;
        cout << "            dsmax=" << dsm
             << " rel.err=" << sm
             << endl;
#endif
#endif
    }
    while (k4<n);

}
/* ===================== end FHT =====================*/

