#if !defined __FXTAUX_H
#define      __FXTAUX_H

// auxiliary functions & #defines for transforms ...


#include "types.h"   // for ulong
#include "sincos.h"  // sincos()

#include <math.h>    // for ldexp(), M_PI
#include <string.h>  // memcpy()

#include <complex.h>
#if defined __COMPLEXT__
#define Complex complex<double>
#endif

// cfftaux.cc:
void complex_to_real_imag(Complex *c, long n);
void real_imag_to_complex(double *fr, double *fi, long n);
void c_scramble(Complex *f, long n);
void c_print(char *what, Complex *c, long n);
void c_copy(Complex *src, Complex *dst, long n);
void dc_copy(double *srcre, double *srcim, Complex *dst, long n);
void cd_copy(Complex *src, double *dstre, double *dstim, long n);
void c_null(Complex *dst, long n);
void c_fill(Complex *dst, long n, Complex val);
void c_rand(Complex *a, long n);



// fhtcnvl.cc:
void fht_convolution_core(double *x, double *y, ulong ldn);

// fhtcnvla.cc:
void fht_auto_convolution_core(double *x, ulong ldn);
void fht_auto_convolution_core_x(double *x, ulong ldn);
void cos_revsin(double *a, ulong  n);


// fftcnvl.cc:
void fft_convolution_core1(double *x, double *y, ulong ldn);
void fft_convolution_core2(double *x, double *y, ulong ldn);

// fftcnvla.cc:
void fft_auto_convolution_core1(double *x, ulong ldn);
void fft_auto_convolution_core2(double *x, ulong ldn);

// fftsd4.cc:
void dif4_fft_core(double *fr, double *fi, ulong ldn, int is);

// fftcl4.cc:
void dit4_fft_core(double *fr, double *fi, ulong ldn, int is);

// fftwide.cc:
void wide_fft(double *fr, double *fi, ulong n, ulong d, double *wr, double *wi, int is);
void wide_fft0(double *fr, double *fi, ulong n, ulong d, double *wr, double *wi, int is);

// graycode.cc:
ulong graycode(ulong x);
ulong inverse_graycode(ulong x);
void gray_scramble(double *f, ulong n);
void gray_scramble_up(double *f, ulong n);
void gray_scramble0(double *f, ulong n);


// walshwide.cc:
void wide_walsh(double *f, ulong n, ulong d, double *w);
void wide_walsh0(double *f, ulong n, ulong d, double *w);


// sincostb.cc:
void make_sincos_table(ulong n, ulong m, double **s, double **c);

// scramble.cc:
void scramble(double *f, ulong n);
void scramble(double *fr, double *fi, ulong n);
void scramble0(double *f, ulong n);
void scramble0(double *fr, double *fi, ulong n);

//fft9.cc:
void fft9(double *fr, double *fi);

//fft8.cc:
void fft8(double *fr, double *fi, int is);

//fft8cl.cc:
void fft8cc(double *fr, double *fi, int is);

//fft8sd.cc:
void fft8ss(double *fr, double *fi, int is);

//fft9.cc:
void fft9(double *fr, double *fi, int is);

//--------------------------------------------

#define USE_SINCOS3
// whether split radix ffts use sincos for triple angle
// else: use algebraic relation

#define SQRT12   0.70710678118654752440084436210484
#define SQRT2    1.414213562373095048801688724209698078569


#define MAX(x,y)     ((x)>(y)?(x):(y))
#define SWAP(x,y)    {double tmp=x; x=y; y=tmp;}
//#define SWAP(x,y)    {typeof(x) tmp=x; x=y; y=tmp;}  // GNU C allows this
// swap for other types:
#define TSWAP(tp,x,y)  {tp tmp=x; x=y; y=tmp;}



//void sumdiff2(double &s, double &d);
//
// s=(s+d)
// d=(s-d)
//
#define sumdiff2(s,d)  { double t=s-d; s+=d; d=t; }


//void sumdiff2_05(double &s, double &d);
//
// s=0.5*(s+d)
// d=0.5*(s-d)
//
#define sumdiff2_05(s,d)  { double t=(s-d)*0.5; s+=d; s*=0.5; d=t; }


//void sumdiff2_x(double &s, double &d, double &x);
//
// s=x*(s+d)
// d=x*(s-d)
//
#define sumdiff2_x(s,d,x)  { double t=(s-d)*x; s+=d; s*=x; d=t; }


//void sumdiff4(double a, double b, double &s, double &d);
//
// NEVER call like func(a,b,a,b) (i.e. input=output)
//
#define sumdiff4(a,b,s,d)  { s=a+b; d=a-b; }


//void sumdiff4_05(double a, double b, double &s, double &d);
//
// NEVER call like func(a,b,a,b) (i.e. input=output)
//
#define sumdiff4_05(a,b,s,d)  { s=(a+b)*0.5; d=(a-b)*0.5; }


//void sumdiff4_x(double a, double b, double &s, double &d, double &x);
//
// NEVER call like func(a,b,a,b,x) (i.e. input=output)
//
#define sumdiff4_x(a,b,s,d,x)  { s=(a+b)*x; d=(a-b)*x; }


//void csqr2(double &u, double &v);
//
// u=u*u-v*v
// v=2*u*v
//
#define csqr2(u,v)  { double t=u*u-v*v; v*=(u+u); u=t; }


//void csqr4(double a, double b, double &u, double &v);
//
// NEVER call like func(a,b,a,b) (i.e. input=output)
//
#define csqr4(a,b,u,v)  { u=a*a-b*b; v=a*b; v+=v; }


//void cmult4(double c, double s, double &u, double &v);
//
// u=u*c-v*s
// v=u*s+v*c
//
#define cmult4(c,s,u,v)  { double t=u*s+v*c; u*=c; u-=v*s; v=t; }


//void cmult6(double c, double s, double c1, double s1, double &u, double &v);
#define cmult6(c,s,c1,s1,u,v)  { u=c1*c-s1*s; v=c1*s+s1*c; }



// floor(log2()):
inline ulong
ld(ulong x)
{
    ulong k = 0;
    while ( x>>=1 )  ++k;
    return k;
}

// copy array:
inline void
d_copy(double *s, double *d, ulong n)
{
    memcpy(d,s,n*sizeof(double));
    //    while ( n-- )  d[n] = s[n];
}
/*  memcpy doc:
  void * memcpy (void *TO, const void *FROM, size_t SIZE)
  undefined if the two arrays TO and FROM overlap;

  void * memmove (void *TO, const void *FROM, size_t SIZE)
  ... even if those two blocks of space overlap.
*/



// set array to zero:
inline void
d_null(double *d, ulong n)
{
    while ( n-- )  d[n] = 0.0;
}

// fill array with one value:
inline void
d_fill(double *dst, ulong n, double d)
{
    while (  n--  )  dst[n] = d;
}

// multiply array by s:
inline void
d_multiply(double *f, ulong n, double s)
{
    while ( n-- )  f[n] *= s;
}

// multiply array by 2^-ex:
inline void
d_multiply2(double *f, ulong n, int ex)
{
   while ( n-- )  f[n] = ldexp(f[n],-ex);
}


inline void
d_sumdiff(double *we, double *wo, ulong n)
{
    while ( n-- )  sumdiff2(we[n],wo[n]);
}

inline void
d_sumdiff_05(double *we, double *wo, ulong n)
{
    while ( n-- )  sumdiff2_05(we[n],wo[n]);
}



#endif  // !defined __FXTAUX_H
