
#include <iostream.h>
#include <math.h>

#include "modm.h"

void fftprimes();
int main() { fftprimes(); return 0; }


void
fftprimes()
{
    int bx = 63;    // max bits: your data type, e.g. 63 or 64 bit 
    // default=63

    // default1: pushing fft length 
    // default2: pushing modulus 
    // ... with 64 bit we are in heaven anyway 
    double bm = bx-0.01;  // min bits
    // default1 = bx-0.5,  default2=bx-0.01 

    // bits search range: 
    int z  = 22;    // bx-z >= log_2(reasonable fft length) 
    // default1 = 10,   default2=23 

    umod_t bx2 = 1ULL<<bx;  // max bits
    umod_t bm2 = (umod_t)pow(2,bm);  //  min bits
    umod_t z2  = 1ULL<<z;  // search range


    for (int r=bx-z; r<=bx; ++r)
    {
        cout << "  ---- r=" << r <<" : ----- \n";
        umod_t r2 = 1ULL<<r;

        umod_t ym = (umod_t)(ceil(bm2/r2)/2)*2-1;  // approx bm2/rx2
        if ( 0==(ym&1) )  ym=ym-1;  // must be odd

        for (umod_t y=ym; y<=(1ULL<<z); y+=2)
        {
            umod_t p = r2*y+1;
            double bits = log(1.0*p)/log(2.0);

            if ( bits>=bx ) break;

            if ( is_prime(p) )
            {
                if  ( bits>=bm )
                {
                    cout << "prime=" << p 
                         << " =2^" << r << "*" << y << "+1 "
                         << hex << " =0x" << p << dec 
                         << " bits=" << bits <<"\n";
                }
            }
        }
    }
}
