
#include <math.h>

#include "mtypes.h"
#include "modm.h"
#include "jjassert.h"


int
is_prime(umod_t n)
//
// rabin miller test
// return 0 if n is (with high probability) composite 
// cf. cohen p.414
//
{
//    cout << " RM: n=" << n << " \n";

    if ( 0==(n&1) )
    {
        if ( 2==n )  return 1;  // prime
        else         return 0;  // composite
    }

    if ( n<1000 )  // eliminate tiny n
    {
        uint s = (uint)sqrt(n);
        uint v;
        for (v=3; v<=s; v+=2)
        {
            if ( ((n/v)*v)==n )  return 0;  // composite
        }

        return 1;  // prime
    }


    // initialize:
    umod_t q = n-1;
    int t = 0;

    while ( 0==(q&1) )
    {
        q >>= 1;
        t++;
    }
//    cout << " RM: q=" << q << " \n";
//    cout << " RM: t=" << t << " \n";


    int c = 0;
    while ( c<20 )
    {
        // choose new a:
        umod_t a = prime(c);
        jjassert( (a!=0)*(int)"is_prime(): need more primes ! " );
//        cout << " RM: a=" << a << " ... \n";
        int e = 0;
        umod_t b = pow_mod(a,q,n);

        if ( 1!=b )
        {
            // squarings:
            while ( (b!=1) && (b!=(n-1)) && (e<=(t-2)) )
            {
//                cout << " RM: b=" << b << " \n";
                b = mul_mod(b,b,n);
                e++;
            }

            if ( b!=(n-1) )
            {
//                cout << " RM: b=" << b << " \n";
//                cout << " RM: composite \n";
                return 0;  // composite
            }
            
        }

        c++;
    }

    return 1;  // prime
}
//================= end IS_PRIME ================
