
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"


//
// stuff here is little tested ...
//

void
slow_auto_correlation(double *f, ulong nu)
//
// _cyclic_ self-correlation
//
{
    slow_correlation(f,f,nu);
}
// ============== end SLOW_AUTO_CORRELATION ================


void
slow_auto_correlation0(double *f, ulong nu)
//
// _cyclic_ self-correlation
// (expects zero padded data)
{
    slow_correlation0(f,f,nu);
}
// ============== end SLOW_AUTO_CORRELATION0 ================


void
slow_correlation(const double *f, double *g, ulong nu)
//
// _cyclic_ correlation
// (use zero padded data for usual co.)
//
// result in g
//
{
    long n=(long)nu;

    double *r=new double[n];

    for(long tau=0; tau<n; ++tau)
    {
	double s=0.0;

	for(long k=0; k<n; ++k)
	{
             long k2=k+tau;
             if(k2>=n)  k2-=n;

	     s += (g[k]*f[k2]);
	}

        r[tau]=s;
    }

    d_copy(r,g,n);

    delete [] r;
}
// ============== end SLOW_CORRELATION ================


void
slow_correlation0(const double *f, double *g, ulong nu)
//
// correlation
// (expects zero padded data)
//
// result in g
//
{
    long n=(long)nu, nh=n/2;

    double *r=new double[n];

    for(long tau=0; tau<nh; ++tau)
    {
	double s=0.0;

	for(long k=0, k2=tau; k2<nh; ++k,++k2)
	{
	     s += (g[k]*f[k2]);
	}

        r[tau]=s;
    }

    for(long tau=nh; tau<n; ++tau)
    {
	double s=0.0;

	for(long k=tau-nh, k2=0; k<nh; ++k,++k2)
	{
	     s += (g[k]*f[k2]);
	}

        r[tau]=s;
    }

    d_copy(r,g,n);

    delete [] r;
}
// ============== end SLOW_CORRELATION0 ================

