
#include <math.h>

#include "fxtaux.h"


void 
slow_ft(double *fr, double *fi, ulong n, int is)
//
// the original SFT (slow fourier transform)
// (may burn your FPU)
//
{
    double *resr=new double[n];
    double *resi=new double[n];

    const double ph0=is*2.0*M_PI/n;

    for(ulong w=0; w<n; ++w)
    {
        double sr=0.0, si=0.0; 
        for(ulong k=0; k<n; ++k)
	{
            double c,s;
            sincos(&c,&s,ph0*k*w);

            double r,i;
            cmult6(fr[k],fi[k],c,s,r,i);

            sr+=r;
            si+=i; 
	}
   
        resr[w]=sr;
        resi[w]=si;
    }


    for(ulong k=0; k<n; ++k)  fr[k]=resr[k];    

    for(ulong k=0; k<n; ++k)  fi[k]=resi[k];    


    delete [] resr;
    delete [] resi;
}
// ================== end SLOW_FT ====================
