
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdatafu.h"
#include "mybuiltin.h"
#include "workspace.h"


// for debug:
//#include <iostream.h>
#define PRZ(x)

#define  AD  a.data()
#define  BD  b.data()
#define  CD  c.data()



int
gt_mul(const hfguts &a, const hfguts &b, hfguts &c,
       ulong pa, ulong pb, ulong pc)
//
// pa, pb, pc default to 0
//
// returns how many right shifts happened
//
{
    PRZ( int flag = 0; );
    PRZ( gt_print("\n gt_mul(): a=",a,0,8); );
    PRZ( gt_print("\n gt_mul(): b=",b,0,8); );
    PRZ( flag = 1; );

    // a identical b with same precison:
    //    if( (&a==&b) && (pa==pb) )  return gt_sqr(a,c,pa,pc);

    assert( c.writeable() );
    assert( pa <= AD->size() );
    assert( pb <= BD->size() );
    assert( pc <= CD->size() );

#if FORBID_UNNORMALIZED
    assert( a.normalized() );
    assert( b.normalized() );
#endif // FORBID_UNNORMALIZED

    if ( a.is_zero() || b.is_zero() )
    {
        c.set_zero();
        return 0;
    }

    c.exp( a.exp()+b.exp()-1 );

    c.sign( a.sign()*b.sign() );

    if( 0==pa )  pa = a.prec();
    if( 0==pb )  pb = b.prec();
    if( 0==pc )  pc = c.prec();


    int i;
    if ( (pa<32) || (pb<32) )
    {
        i = dt_mul_slow(*AD, pa, *BD, pb, *CD, pc);
    }
    else
    {
        switch( gws.howto_mul(MAX(pa,pb)) )
        {
        case 0:
            {
                //                if ( pa>256 ) // test dt_mul_sqr()
                //                    i = dt_mul_sqr(*AD, pa, *BD, pb, *CD, pc);
                //                else
                    i = dt_mul_fxt(*AD, pa, *BD, pb, *CD, pc);

                break;
            }

        case 1:
            {
                i = dt_mul_sqr(*AD, pa, *BD, pb, *CD, pc);
                break;
            }

        case 2:
            {
                i = 0;
                assert( 0*(int)"mass storage mult not implemented" );
                break;
            }

        default:
            {
                i = 0;
                assert( 0*(int)"invalid method for mult" );
            }
        }
    }

    c.exp( c.exp()+i );

    PRZ( if ( flag )  gt_print("\n gt_mul(): c=",c,0,8); );


#if FORBID_UNNORMALIZED
    assert( c.normalized() );
#endif // FORBID_UNNORMALIZED

    return i;
}
//======================== end GT_MUL =======================
