
#include "hfloatfu.h"
#include "hfverbosity.h"
#include "hfgutsfu.h"


#define A *(a.guts())
#define B *(b.guts())
#define C *(c.guts())


hfloat
sqr(const hfloat &h)
{
    hfloat h3;
    sqr(h,h3);
    return h3;
}
// -----------------

hfloat
mul(const hfloat &h1, const hfloat &h2)
{
    hfloat h3;
    mul(h1,h2,h3);
    return h3;
}
// -----------------



void
sqr(const hfloat &a, hfloat &c, ulong pa, ulong pc)
//
// pa, pc default to 0
//
{
    say( hfverbosity::sqr );

    gt_sqr(A,C,pa,pc);
}
//===================== end SQR ================================


void
mul(const hfloat &a, const hfloat &b, hfloat &c, 
    ulong pa, ulong pb, ulong pc)
//
// pa, pb, pc default to 0
//
{
    say( hfverbosity::mul );

    if( pa==1 )
    {
        long i;
        hfloat2i(a,i);
        gt_mul_int( B, i, C);
    }

    if( pb==1 )
    {
        long i;
        hfloat2i(b,i);
        gt_mul_int( A, i, C);
    }

    gt_mul(A,B,C,pa,pb,pc); 
}
//===================== end MUL ================================



void
mul(const hfloat &a, long i, hfloat &c)
{
    say( hfverbosity::mulint );

    gt_mul_int(A,i,C);
}
//===================== end MUL ================================



void
mul_by_radix_pow(const hfloat &a, int ex, hfloat &b)
{
    b = a;
    b.guts()->exp( b.guts()->exp() + ex );
}
//===================== end MUL_BY_RADIX_POW ==========================



