
#include "mybuiltin.h"

#if defined __GNUC__

#warning "FYI: using GNU C TIMER (which returns user time)"

#else

#warning "FYI: using gettimeofdy() TIMER (which returns wall clock time)"

//#include <unistd.h>
#include <sys/time.h>  // gettimeofday()


static struct timeval t0, t1;

void
start_timer()
{
    gettimeofday( &t0, NULL );
}
// ----------------------------

//
// time (in seconds) elapsed since call of start_timer()
// resolution is microseconds, accuracy may be much less
//
double
return_elapsed_time()
{
    gettimeofday( &t1, NULL );

    double dt =
        ((double)t1.tv_sec  - (double)t0.tv_sec) +
        ((double)t1.tv_usec - (double)t0.tv_usec)*1e-6;

    return dt;
}
// ----------------------------

/*
// alternative:

#include <time.h>

static time_t t0;

void
start_timer()
{
    t0 = clock();
}

double
return_elapsed_time()
{
    return  1.0*(clock()-t0)/CLK_TCK;
}
*/


#endif // !defined __GNUC__
