
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <stdlib.h>  // for exit()

#include "hfloatfu.h"
#include "hfgutsfu.h"


// for debug:
#define PR(x)

#define SAFE(x) x

void
print(const hfloat &r, ulong n)  // =0
{
    save(cout,"",r,n);
}
//================ end PRINT ====================


void
print(const char *what, const hfloat &a, ulong n)  // =0
{
    save(cout,what,a,n);
}
//================== end PRINT =============================


void
print_last(const char *what, const hfloat &a, ulong n)
{
    save_last(cout,what,a,n);
}
//================== end PRINT_LAST ========================


void
save(ostream &os, const hfloat &r, ulong n)  // =0
{
    if ( n==0 )  n=r.prec();

    gt_save(os,"", *r.guts() ,0,n);
}
//================ end SAVE ====================

void
save(ostream &os, const char *what, const hfloat &a, ulong n)  // =0
{
    if ( n==0 )  n=a.prec();

    gt_save(os, what, *a.guts(), 0, n);
}
//================== end SAVE =============================


void
save_last(ostream &os, const char *what, const hfloat &a, ulong n)
{
    ulong s;
    if ( n>a.prec() )  s = 0;
    else               s = a.prec()-n;

    gt_save(os, what, *a.guts(), s, a.prec());
}
//================== end SAVE_LAST =======================


void
save(const char* fname, const hfloat &r)
{
    ofstream datfile;

    datfile.open(fname,ios::out);
    assert(datfile!=NULL);

    save(datfile,NULL,r,r.prec());

    datfile.flush();

    if(datfile.fail())
    {
	cerr<<"\n save(): ERROR saving data ! (exiting) "<<endl;
	exit(-666);
    }

    datfile.close();
}
//================ end SAVE ====================
