#if !defined __HFGUTSFU_H
#define      __HFGUTSFU_H

#include <iostream.h>

#include "types.h"     // says LIMB:=unsigned short
#include "hfguts.h"    // class hfguts


ulong gt_from_int(long i, hfguts &a);
ulong gt_from_uint(ulong i, hfguts &a);
ulong gt_from_string(const char *str, hfguts &a);
ulong gt_from_double(double d, hfguts &a);

int gt_to_int(const hfguts &a, long &i);
int gt_to_double(const hfguts &a, double &b);
int gt_to_string(const hfguts &a, char *str);


void gt_dump(const char *bla, const hfguts &a, long prn);

int  gt_print(const char *what, const hfguts &a, ulong s, ulong e);
int  gt_save(ostream &os, const char *what, const hfguts &a, ulong s, ulong e);


//int  gt_same_mantissa(const hfguts &a, const hfguts &b);
//void gt_copy(const hfguts &src, hfguts &dst);
void gt_rand(hfguts &a);

int gt_addsub(const hfguts &a, const hfguts &b, hfguts &c, int subq);
int gt_addsub_int(const hfguts &a, long i, hfguts &c, int subq);

int gt_sqr(const hfguts &a, hfguts &c, ulong pa=0, ulong pc=0);

int gt_mul(const hfguts &a, const hfguts &b, hfguts &c, 
           ulong pa=0, ulong pb=0, ulong pc=0);
int gt_mul_int(const hfguts &a, long i, hfguts &c);
int gt_mul_slow(const hfguts &a, const hfguts &b, hfguts &c);


//int gt_div(const hfguts &a, const hfguts &b, hfguts &c);
int gt_div_int(const hfguts &a, long i, hfguts &c, int *rem=0);
int gt_div_slow(const hfguts &a, const hfguts &b, hfguts &c);


long gt_cmp(const hfguts &a, const hfguts &b);
long gt_cmp_abs(const hfguts &a, const hfguts &b);
//long gt_cmp_dig(const hfguts &a, const hfguts &b);
long gt_cmp_one(const hfguts &a, ulong startdig);

int gt_ldexp(const hfguts &x, long p, hfguts &a);
int gt_mul2pow(const hfguts &x, ulong p, hfguts &a);
int gt_div2pow(const hfguts &x, ulong p, hfguts &a);
int gt_mul2(const hfguts &x, hfguts &a);
int gt_div2(const hfguts &x, hfguts &a);

 
#endif // !defined __HFGUTSFU_H
