#if !defined __HFLOAT_H
#define      __HFLOAT_H


#include <assert.h>

//#include "hfguts.h"
#include "types.h"


// the class 'hfloat_init' has the sole purpose
// of initialising the class 'hfloat'
// this is done with the static member 'hfloat_zero'
// of class 'hfloat'


class  hfloat_init
{
public:
    hfloat_init(int helloq, LIMB rx, ulong prec, 
                int cnvl, int acnvl, 
                int checkmul, int checkroots);

    ~hfloat_init();  // 'hfloat_exit()'
};
//--------------------------

class  hfloat // "_huge_float_"
{
public:

// constructors & destructor:

    hfloat();
    explicit hfloat(ulong prec);
    hfloat(const hfloat &);
    ~hfloat();

    hfloat& hfloat::operator =(int);
    hfloat& hfloat::operator =(long);
    hfloat& hfloat::operator =(ulong);
    hfloat& hfloat::operator =(double);
    hfloat& hfloat::operator =(const hfloat &);
    hfloat& hfloat::operator =(const char *);

    int     hfloat::id() const;
    void    hfloat::size(ulong);
    ulong   hfloat::size() const;
    void    hfloat::prec(ulong);
    ulong   hfloat::prec() const;
    void    hfloat::dec_prec(ulong);
    ulong   hfloat::dec_prec() const;
    void    hfloat::bit_prec(ulong);
    ulong   hfloat::bit_prec() const;
    int     hfloat::positive() const;
    int     hfloat::negative() const;
    int     hfloat::is_zero() const;
    void    hfloat::set_zero();
    void    hfloat::negate();
    int     hfloat::sign() const;
    void    hfloat::sign(int);
    long    hfloat::exp() const;
    void    hfloat::exp(long);
    ulong   hfloat::radix() const;
    LIMB    hfloat::get_limb(ulong) const;
    void    hfloat::set_limb(ulong,LIMB);
    void    hfloat::ensure_own_data(ulong n=0);
    void    hfloat::make_own_data(ulong n=0);
    int     hfloat::same_mantissa(const hfloat &h) const;
    void    hfloat::copy(const hfloat &h);
    void    hfloat::check() const;
    hfguts* hfloat::guts() const;

private:
    void hfloat::set_unique_id(); // for constructors

    // ---- implementation:
    int           hfid;           // unique identity number !=0  id()
    hfguts*       gt;             // the number


public:
    static void   hello();
    static void   statistics(ulong n);

    static ulong  max_max_prec();   // how many LIMBs can be multiplied at max
    static ulong  max_prec();       // current max_precision
    static void   max_prec(ulong);

    // currently same radix for all hfloats:
    static ulong  radix();
    static void   radix(ulong);

    static const char *version(); 

    // whether to check iteration for nth root:
    static int    check_itiroot_result;

private:
    static ulong  max_precision;      // for the hfloat() constructor


    static char * version_string;     // string like "05-june-1997"

    // magic initialiser:
    static hfloat_init hfloat_initialiser;
};
//------ end class hfloat -----------------------------------




#endif // !defined __HFLOAT_H
