(* mathematica definitions for ramanujan-type formulas *)


Clear[ellK,ellE]
ellK[x_]:=EllipticK[x^2]
ellE[x_]:=EllipticE[x^2]


Clear[Jla]

Jla[n_,acc_:33]:=Block[{q,la},
    la=k[n,acc]^2;
    q=N[4/27*(1-la+la^2)^3/la^2/(1-la)^2,acc];

Return[q]
]


Clear[k]   (* k_p *)

k[n_,acc_:33]:=Block[{q,k},
    q=N[Exp[-Pi*Sqrt[n]],acc];
    k=(EllipticTheta[2,0,q]/EllipticTheta[3,0,q])^2;
Return[k]
]


Clear[al]  (* alpha_p *)

al[n_,acc_:33]:=Block[
{kv,K,E,kvp,Kp,Ep,alv}
    ,
    kv=k[n,acc];
    K=ellK[kv];
    E=ellE[kv];
    alv=N[Pi/(4*K^2)-Sqrt[n]*(E/K-1), acc];
Return[alv]
]


Clear[gm12]

gm12[n_,acc_:33]:=Block[{kv,gv},
    kv=k[n,acc];
    gv=N[2*kv/Sqrt[1-kv^2]^2,acc];

Return[gv]
]


Clear[Gm12]

Gm12[n_,acc_:33]:=Block[{},
    kv=k[n,acc];
    gv=N[2*kv*Sqrt[1-kv^2],acc];

Return[gv]
]


Clear[g1]

g1[n_,acc_:33]:=N[Power[gm12[n,acc],-1/12],acc]


Clear[G1]

G1[n_,acc_:33]:=N[Power[Gm12[n,acc],-1/12],acc]



Clear[J]

J[n_,acc_:33]:=Block[{G24,jv},
    G24=1/Gm12[n,acc]^2;
    jv=N[(4*G24-1)^3/(27*G24),acc];

Return[jv]
]


Clear[j]

j[n_,acc_:33]:=Block[{jv},
    jv=N[1728*J[n,acc],acc];

Return[jv]
]

(* ----------------------- type 1 ------------------------------------*)
Clear[t1]

t1[a_,b_,x_,n_Integer?NonNegative]:=
Sum[
Pochhammer[1/4,k]*
Pochhammer[2/4,k]*
Pochhammer[3/4,k]/
(k!)^3 *
(a+k b)/x^(2*k+1)
,{k,0,n}]


Clear[x,a1,b1]

x[n_,acc_:33]:=Block[{tmp},
    tmp=gm12[n,acc];
    tmp=(tmp+1/tmp)/2;
Return[tmp];
]


a1[n_,acc_:33]:=Block[{av,bv,tmp},
    tmp=gm12[n,acc];
    av=N[al[n,acc]* x[n,acc]/(1+k[n,acc]^2)-Sqrt[n]/4*tmp,acc];
Return[av]
]


b1[n_,acc_:33]:=Block[{bv,tmp},
    tmp=gm12[n,acc];
    bv=(-tmp+1/tmp)/2;
    bv=N[Sqrt[n]*bv,acc];
Return[bv]
]


(* ----------------------- type 2 ------------------------------------*)
Clear[t2]

t2[a_,b_,y_,n_Integer?NonNegative]:=
Sum[
(-1)^k*
Pochhammer[1/4,k]*
Pochhammer[2/4,k]*
Pochhammer[3/4,k]/
(k!)^3 *
(a+k b)/y^(2*k+1)
,{k,0,n}]


Clear[y,a2,b2]

y[n_,acc_:33]:=Block[{tmp},
    tmp=Gm12[n,acc];
    tmp=(-tmp+1/tmp)/2;
Return[tmp];
]


a2[n_,acc_:33]:=Block[{av,bv,tmp,tk},
    tmp=Gm12[n,acc];
    tk=k[n,acc];
    av=N[al[n,acc]*y[n,acc]/(1-2*tk^2)+Sqrt[n]/2*tk^2/tmp,acc];
Return[av]
]


b2[n_,acc_:33]:=Block[{bv,tmp,tk},
    tmp=Gm12[n,acc];
    bv=(tmp+1/tmp)/2;
    bv=N[Sqrt[n]*bv,acc];
Return[bv]
]


(* ----------------------- type 3 ------------------------------------*)
Clear[t3]

t3[a_,b_,sj_,n_Integer?NonNegative]:=
1/(Sqrt[3*sj])*
Sum[
Pochhammer[1/6,k]*
Pochhammer[3/6,k]*
Pochhammer[5/6,k]/
(k!)^3 *
(a+k b)/sj^(k)
,{k,0,n}]


Clear[a3,b3]

a3[n_,acc_:33]:=Block[{av,kv,G24v,Gm24v,alv},
    kv=k[n,acc];
    alv=al[n,acc];
    Gm24v=Gm12[n,acc]^2;
    G24v=1/Gm24v;
    av=N[1/(3*Sqrt[3])*(Sqrt[n]*Sqrt[1-Gm24v]
        +2*(alv-Sqrt[n]*kv^2)*(4*G24v-1)),acc];
Return[av]
]


b3[n_,acc_:33]:=Block[{bv,G24v,Gm24v},
    Gm24v=Gm12[n,acc]^2;
    G24v=1/Gm24v;
    bv=N[Sqrt[n]*2/(3*Sqrt[3])*((8*G24v+1)*Sqrt[1-Gm24v]),acc];
Return[bv]
]


(* ---- case a: ---- *)

Clear[a3a,b3a,Ja]

a3a[n_,acc_:33]:=Re[N[Sqrt[-1728]*a3[((Sqrt[n]-I)/2)^2,acc+5],acc]]

b3a[n_,acc_:33]:=Re[N[Sqrt[-1728]*b3[((Sqrt[n]-I)/2)^2,acc+5],acc]]

J3a[n_,acc_:33]:=J[((Sqrt[n]-I)/2)^2,acc]

(* ---- case b: ---- *)

Clear[a3b,b3b,Jb]

a3b[n_,acc_:33]:=N[Sqrt[3]*a3[n,acc+5],acc]

b3b[n_,acc_:33]:=N[Sqrt[3]*b3[n,acc+5],acc]

J3b[n_,acc_:33]:=J[n,acc]

(* ---- case c: ---- *)

Clear[a3c,b3c,Jc]

a3c[n_,acc_:33]:=Re[N[Sqrt[-12]*a3[((Sqrt[n]-I)/2)^2,acc+5],acc]]

b3c[n_,acc_:33]:=Re[N[Sqrt[-12]*b3[((Sqrt[n]-I)/2)^2,acc+5],acc]]

J3c[n_,acc_:33]:=J[((Sqrt[n]-I)/2)^2,acc]

(*------------------------------------------------------------------*)
(*------------------------------------------------------------------*)

Clear[clt,clt744]

clt[x_,acc_:133]:=Block[{t,rt},
    t=N[Exp[Pi*Sqrt[x]],acc];
    rt=Round[t];
    t=Log[Abs[rt-t]];
    t=SetAccuracy[t,7];

Return[t]
]

clt744[x_,acc_:133]:=Block[{t,rt},
    t=N[Power[Exp[Pi*Sqrt[x]]-744,1/3],acc];
    rt=Round[t];
    t=Log[Abs[rt-t]];
    t=SetAccuracy[t,7];

Return[t]
]

(*------------------------------------------------------------------*)

Clear[rec,recf]

rec[x_, n_Integer?Positive, t_Symbol, k_Integer:0, acc_:33] :=
	Block[{data, i, scale},
        If[IntegerQ[x] || ! NumberQ[x], Return["error"],
			data = Table[x^i, {i, 0, n}];
            data = Round[data 10^acc];
			scale = Table[(k+1)^i, {i, 0, n}];
			data = Transpose[ Append[ DiagonalMatrix[scale], data ]];
			data = Drop[LatticeReduce[data][[1]], -1];
			Table[t^i, {i, 0, n}] . (data/scale)
			]
		]

recf[x___]:=Factor[rec[x]]

(*------------------------------------------------------------------*)

Clear[frt]
frt[eq_,var_,start_:.1,it_:55,wp_:80,acg_:(10^-50)]:=
FindRoot[eq,{var,start},MaxIterations->it,WorkingPrecision->wp,AccuracyGoal->acg]

Clear[fa,fi]

fa[x_Integer]:=FactorInteger[x,FactorComplete->False]
SetAttributes[fa,Listable]
fi[x_Integer]:=FactorInteger[x^2+1,FactorComplete->False]
SetAttributes[fi,Listable]


Clear[rr3]

rr3[x_]:=Power[Abs[Re[x]],1/3]

