
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"
#include "mybuiltin.h"


int
j_mean(const hfloat &a, const hfloat &b, hfloat &x)
//
//
//
//
//
{
    ulong k;
    ulong prec, precgoal;
    hfloat ak(x.prec()), bk(x.prec());

    precgoal = x.prec();
    if ( a.prec()<precgoal )  precgoal=a.prec();
    if ( b.prec()<precgoal )  precgoal=b.prec();

    // ---- first step:
    sqr(a,ak);
    sqr(b,bk);
    add(ak,bk,bk);
    div(bk,2,bk);
    sqrt(bk,bk);  // sqrt((a^2+b^2)/2)

    add(a,b,ak);
    div(ak,2,ak); // (a+b)/2

    prec=cmp(ak,bk);

    // ---- more steps:
    k=1;
    while ( prec!=0 && prec<precgoal/2 )
    {
        k++;
        sqr(ak,x);     
        add(ak,bk,ak);
	div(ak,2,ak);      // a_new = (a+b)/2
	sqr(bk,bk);
        add(x,bk,bk);
        div(bk,2,bk);
	sqrt(bk,bk);    // b_new = sqrt((a^2+b^2)/2)

	//	print("a=",ak);
	//	print("b=",bk);

	prec = ABS(cmp_limbs(ak,bk));

	//	cout<<"prec="<<prec<<endl;
    }

    add(ak,bk,ak);
    div(ak,2,x);    // (a+b)/2

    return k;
}
//======================= end J_MEAN ======================



int
agm(const hfloat &a, const hfloat &b, hfloat &x)
//
//  arithmetic_geometric_mean
//
//  AGM(a,b):=
//  common limit after repeated application of 
//  {x,y} |--> {(x+y)/2,sqrt(x*y)} 
//  starting with {a,b}
//
// returns number of steps needed
//
{
    ulong k;
    ulong prec, precgoal;
    hfloat ak(x.prec()), bk(x.prec());

    precgoal = x.prec();
    if ( a.prec()<precgoal )  precgoal=a.prec();
    if ( b.prec()<precgoal )  precgoal=b.prec();


    // ---- first step:
    add(a,b,ak);
    div(ak,2,ak); 
    mul(a,b,bk);
    sqrt(bk,bk);
    prec=cmp(ak,bk);
    
    // ---- more steps:
    k=1;
    while ( prec!=0 && prec<precgoal/2 )
    {
        k++;
        add(ak,bk,x);   // a+b
	mul(ak,bk,bk);  // a*b
	sqrt(bk,bk);    // b_new = sqrt(a*b)
	div(x,2,ak);    // a_new = (a+b)/2

	//	print("a=",ak);
	//	print("b=",bk);

	prec = ABS(cmp_limbs(ak,bk));

	//	cout<<"prec="<<prec<<endl;
    }

    add(ak,bk,ak);
    div(ak,2,x);    // (a+b)/2

    return k;
}
//======================= end AGM ======================



int
hgm(const hfloat &a, const hfloat &b, hfloat &x)
//
//  harmonic_geometric_mean
//
//  HGM(a,b):=
//  common limit after repeated application of 
//  {x,y} |--> {2*x*y/(x+y),sqrt(x*y)} 
//  starting with {a,b}
//
//  HGM(1,n)=2/Pi*log(4*n)+O(1/n^2)
//
//  if y:=(x^n)/4 
//  then
//  n*y*(HGM(1,y+1)/HGM(1,y)-1)=1/log(x)+O(n/3^n)
//  and
//  n*(HGM(1,n+1)-HGM(1,n))=2/Pi+O(1/n)
//
//  HGM(a,b)=a*b/agm(a,b)
//
// see: newman: a simplified version ...,
//       math. comp. (44) 1985 pp.207-210
//
// returns number of steps needed
//
{
    hfloat ak(x.prec());

    mul(a,b,ak);

    int  ret = agm(a,b,x);

    div(ak,x,x);

    return ret;
}
//======================= end HGM ======================

