#include <math.h>
#include <std.h>
#include <iostream.h>
#include <assert.h>
#include <values.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"


//#define TEST_CONV
//#define TEST_ADD
//#define TEST_ADD2
//#define TEST_CMP     
//#define TEST_ADD_SH
#define TEST_OP 


void cmp_them(hfloat a, hfloat b)
{
    int cab, cba;

    print("\n a=",a,5);
    print(" b=",b,5);

    cab=cmp(a,b);
    cba=cmp(b,a);

    assert(cab==-cba);

    cout<<"\n cmp(a,b)="<<cab<<endl; 
}



//------------------------------------------------------------------
int test0(long nn)
{
    hfloat a(nn),b(nn),c(nn),d(nn);

    cout<<"\n TEST0 "<<flush;

// ---------- conversion:
#if defined TEST_CONV

    int i;
    i=i2hfloat(1,a);
    print("\n TEST: a=\n",a);
    cout<<"\n i="<<i<<endl;

#endif



// ---------- addition  (add):
#if defined TEST_ADD

    a.prec(4); b.prec(4); c.prec(4); d.prec(4);

    cout<<"\n TEST --------------------------- "<<endl;
    a=+1000000;
    b=+1;
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

    cout<<"\n TEST --------------------------- "<<endl;
    a=+1000000;
    b=-1;
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

    cout<<"\n TEST --------------------------- "<<endl;
    a=-1000000;
    b=+1;
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

    cout<<"\n TEST --------------------------- "<<endl;
    a=-1000000;
    b=-1;
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

#endif  // defined TEST_ADD


#if defined TEST_ADD2

    char sa[128];
    char sb[128];

//    sa=".0001000000000000000000012345678901234*10000^1";
//    sb=    ".999999999999999999912345678901234*10000^0";

    sa=".8535533905932737622004221810*10000^0";
    sb=".8408964152537145430311254762*10000^0";

    cout<<"\n TEST --------------------------- "<<endl;
    a=sa;
    b=sb;
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

    cout<<"\n TEST --------------------------- "<<endl;
    a=sa;
    b=sb; b.negate();
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

    cout<<"\n TEST --------------------------- "<<endl;
    a=sa; a.negate();
    b=sb; 
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

    cout<<"\n TEST --------------------------- "<<endl;
    a=sa; a.negate();
    b=sb; b.negate();
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);
    add(a,b,c); print("\n TEST: a+b=",c);
    add(b,a,c); print("\n TEST: b+a=",c);
    sub(a,b,c); print("\n TEST: a-b=",c);
    sub(b,a,c); print("\n TEST: b-a=",c);

#endif  // defined TEST_ADD2


// ---------- cmp:
#if defined TEST_CMP

    random(a);
    a.exp(3);
    a.sign(1);

    cout << "\n\n identical ... ";
    copy(a,b);  // identical numbers
    cmp_them(a,b); 

    cout << "\n\n diff signs ";
    copy(a,b);
    b.sign(-b.sign());          // signs different
    cmp_them(a,b); 

    cout << "\n\n diff exp I ";
    copy(a,b);
    b.exp(-b.exp());          // exps different
    cmp_them(a,b);

    cout << "\n\n diff exp II ";
    copy(a,b);
    b.exp(b.exp()+1);          // exps different
    cmp_them(a,b);

    cout << "\n\n diff dig[0]";
    copy(a,b); 
    b.set_limb(0,RADIX-b.get_limb(0)); // most significant dig diff
    cmp_them(a,b);

    cout << "\n\n diff dig[1]";
    copy(a,b); 
    b.set_limb(1,RADIX-b.get_limb(1)); // most significant dig diff
    cmp_them(a,b);

    cout << "\n\n diff dig[2]";
    copy(a,b); 
    b.set_limb(2,RADIX-b.get_limb(2)); // most significant dig diff
    cmp_them(a,b); 
#endif  // defined TEST_CMP



#if defined TEST_OP

    a=123;
    b=10000;
    print("\n TEST: a=",a);
    print("\n TEST: b=",b);

    c=a+b;
    print("\n TEST: a+b=",c);

    d=1+2*(a+(b+c));
    print("\n TEST: 1+2*(a+(b+c))=",d);

#endif


    cout<<endl;

    return 0;
}
//============================ end TEST0 ===============================


