#include <math.h>
#include <std.h>
#include <iostream.h>
#include <assert.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/hfgutsfu.h"
#include "../src/include/hfdatafu.h"
#include "../src/include/workspace.h"
#include "../src/include/mybuiltin.h"
#include "../src/dt/auxid.h"

#include "../src/fxt/fxt.h"
//#include "../src/fxt/pfafft.h"



// time the functions:


const int doall = 1;


const int  TIME_ADD = 0;
const int  TIME_ADD_INT = 0;
const int  TIME_MUL_SH = 0;
const int  TIME_MUL_DIR = 0;
const int  TIME_FHT = 0;
const int  TIME_FHT0 = 0;
const int  TIME_FFT = 0;
const int  TIME_PFAFFT = 0;  // might cause problems
const int  TIME_SQR_FXT = 1;
const int  TIME_MUL_FXT = 0;
const int  TIME_MUL_SQR = 0;
const int  TIME_DIV_SH = 0;
const int  TIME_DIV_SEMI_SH = 0;



static int mct;
static double dt,tt,t0;


void
PRINTITX(char *bla)
{
    dt=return_elapsed_time()-t0;
    tt=dt/(double)mct;
    double  opsec = (tt==0?0:1.0/tt);
    cout.form(" %16s:  %8.5g Hz , (%8.5g sec/op)", bla,opsec,tt);
    cout.form("  [dt=%5.3g  mct=%7d]",dt,mct);
    cout<<endl;
}


int
time_functions(long n1, long n) // --------------------------------------
{
    int k,j, tmpi;
    hfloat a(n),b(n),c(n);
    hfguts &ag=*a.guts(), &bg=*b.guts(), &cg=*c.guts();
    hfdata &ad=*ag.data(), &bd=*bg.data(), &cd=*cg.data();
    
    tmpi=0;

    rand(a);
    a.sign(+1);
    a.exp(+17);

    rand(b);
    b.sign(+1);
    b.exp(+8);


    print("\n a=",a,8);
    print("\n b=",b,8);
    cout << "\n\n";



    for(j=MAX(n1,8); j<=n; j*=2) 
    {
        a.prec(j); b.prec(j); c.prec(j);

        cout << " ------------- prec =" << j
             << " LIMBs (=" << a.dec_prec()
             << " dec.dig., =" << a.bit_prec()
             << " bits): -------------- "
             << endl;


        mct=MAX((1<<16)/j,1);

        if ( doall || TIME_MUL_FXT )
        {
            t0=0;
            start_timer();
            for(k=0; k<mct; ++k)
                dt_mul_fxt(ad,j,bd,j,cd,j);

            PRINTITX("fxt_mul.........");
        }


        if ( doall || TIME_MUL_SQR )
        {
            t0=0;
            start_timer();
            for(k=0; k<mct; ++k)
                dt_mul_sqr(ad,j,bd,j,cd,j);

            PRINTITX("fxt_mul_sqr.....");
        }


        if ( doall || TIME_SQR_FXT )
        {
            start_timer();
            for(k=0; k<mct; ++k)
                dt_sqr_fxt(ad,j,cd,j);

            PRINTITX("fxt_sqr.........");
        }


        if ( doall || TIME_MUL_DIR )
        {
            if(j<=2048)
            {
                tmpi=mct;
                mct=32*mct/(j);
                mct=MAX(mct,1);

                t0=0;
                start_timer();
                for(k=0; k<mct; ++k)
                    dt_mul_slow(ad,j,bd,j,cd,j);

                PRINTITX("slow_mul........");

                mct=tmpi;
            }
        }



        mct=MAX((1<<19)/j,1);

        if ( doall || TIME_FHT )
        {
            double *dws=(double*)gws.get_ws_doubles(j);

            tmpi = ld(j);

            start_timer();

            for(k=0; k<mct; ++k)
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j);

            t0=return_elapsed_time();

            start_timer();
            for(k=0; k<mct; ++k)
            {
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j);
                fht(dws,tmpi);
            }

            PRINTITX("fht.............");
            gws.let_ws(dws);
        }


        if ( doall || TIME_FHT0 )
        {
            double *dws=(double*)gws.get_ws_doubles(j);

            tmpi = ld(j);
            start_timer();
            for(k=0; k<mct; ++k)
            {
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j/2);
                d_null(dws+j/2,j/2); 
            }
            t0=return_elapsed_time();

            start_timer();
            for(k=0; k<mct; ++k)
            {
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j/2);
                d_null(dws+j/2,j/2); 
                fht0(dws,tmpi);
            }

            PRINTITX("fht0............");
            gws.let_ws(dws);
        }


#define PFAQ 1

        if ( doall || TIME_FFT )
        {
            double *dws=(double*)gws.get_ws_doubles(j);
            double *dw2=(double*)gws.get_ws_doubles(j);

            tmpi = ld(j);

            start_timer();

            for(k=0; k<mct; ++k)
            {
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j);
                id_copy(b.guts()->data()->dig(),b.prec(),dw2,j);
            }

            t0=return_elapsed_time();

            start_timer();
            for(k=0; k<mct; ++k)
            {
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j);
                id_copy(b.guts()->data()->dig(),b.prec(),dw2,j);

                fht_fft(dws,dw2,tmpi,-1);
            }

            PRINTITX("fft.............");
            gws.let_ws(dw2);
            gws.let_ws(dws);
        }


        /*
        if ( doall || TIME_PFAFFT )
        {
            double *dws=(double*)gws.get_ws_doubles(j);
            double *dw2=(double*)gws.get_ws_doubles(j);

            long tj=j; 
            j=npfa(j);

            start_timer();

            for(k=0; k<mct; ++k)
            {
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j);
                id_copy(b.guts()->data()->dig(),b.prec(),dw2,j);
            }

            t0=return_elapsed_time();

            start_timer();
            for(k=0; k<mct; ++k)
            {
                id_copy(a.guts()->data()->dig(),a.prec(),dws,j);
                id_copy(b.guts()->data()->dig(),b.prec(),dw2,j);

                pfacc(-1, j, (Complex *)dws);
            }

            PRINTITX("pfa_fft.........");
            cout<<" npfa()="<<j<<endl;

            gws.let_ws(dw2);
            gws.let_ws(dws);

            j=tj;
        }
        */


        mct=MAX((1<<20)/j,1);


        if ( doall || TIME_ADD )
        {
            t0=0;
            start_timer();
            for(k=0; k<mct; ++k)
                add(a,b,c);

            PRINTITX("add.............");
        }



        if ( doall || TIME_ADD_INT )
        {
            t0=0;
            start_timer();
            for(k=0; k<mct; ++k)
                add(a,99999,c);

            PRINTITX("add_int.........");
        }


        mct=MAX((1<<22)/j,1);

        if ( doall || TIME_MUL_SH )
        {
            t0=0;
            start_timer();
            for(k=0; k<mct; ++k)
                mul(a,999,c);

            PRINTITX("mul_short.......");
        }



        if ( doall || TIME_DIV_SH )
        {
            t0=0;
            start_timer();
            for(k=0; k<mct; ++k)
                div(a,3,c);

            PRINTITX("div_short.......");
        }


        if ( doall || TIME_DIV_SEMI_SH )
        {
            tmpi=mct;
            mct=MAX(1,mct/4);
            t0=0;
            start_timer();
            for(k=0; k<mct; ++k)
                div(a,999999,c);
    
            PRINTITX("div_semi_short..");
    
            mct=tmpi;
        }
    }// -------------- end of loop --------------


    return 0;
}
//================================= end TIME_FUNCTIONS =======================

