#include <math.h>
#include "ap.h"
#include "apint.h"


// Overloaded apint functions


// Positive integer power
apint pow (apint base, unsigned long exp)
{
    apint r;

    if (!exp) return 1;

    while (!(exp & 1))
    {
        base *= base;
        exp >>= 1;
    }
    r = base;

    while (exp >>= 1)
    {
        base *= base;
        if (exp & 1) r *= base;
    }

    return r;
}

apint pow (apint base, unsigned exp)
{
    return pow (base, (unsigned long) exp);
}

// Integer power
apint pow (apint base, long exp)
{
    if (exp < 0)
        return 0;
    else
        return pow (base, (unsigned long) exp);
}

apint pow (apint base, int exp)
{
    if (exp < 0)
        return 0;
    else
        return pow (base, (unsigned long) exp);
}

// Absolute value
apint abs (apint x)
{
    if (x.sign () >= 0)
        return x;
    else
        return -x;
}

// Quotient and remainder
apdiv_t div (apint numer, apint denom)
{
    size_t s;
    apfloat q, r, a, b, tx, ty;
    apdiv_t v;

    assert (denom.sign ());

    a = abs (numer.val);
    b = abs (denom.val);

    if (a < b)
    {
        v.quot = 0;
        v.rem = numer;

        return v;                   // abs (numer) < abs (denom)
    }
    else
        s = numer.exp () - denom.exp () + 3 * Basedigits;   // Some extra precision

    tx = numer.val;
    ty = denom.val;

    tx.prec (s);
    ty.prec (s);

    q = tx / ty;                    // Approximate division
    q = apfloat (apabsfloor (q.ap));

    r = numer - q * denom;

    a = abs (r);

    if (a >= b)                     // Fix division round-off error
    {
        q += q.sign ();
        r = numer.sign () * (a - b);
    }

    v.quot = q;
    v.rem = r;

    return v;
}

// Greatest common divisor
apint gcd (apint a, apint b)
{
    while (b.sign ())
    {
        apint r = a % b;
        a = b;
        b = r;
    }

    return abs (a);
}

// Least common multiple
apint lcm (apint a, apint b)
{
    return a * b / gcd (a, b);
}
