#include "ap.h"
#include "apint.h"


apint operator/ (const apint &d1, const apint &d2)
{
    size_t s;
    apfloat t, a, b, tx, ty;

    assert (d2.sign ());

    a = abs (d1.val);
    b = abs (d2.val);

    if (a < b)
        return 0;                   // abs (d1) < abs (d2)
    else
        s = d1.exp () - d2.exp () + 3 * Basedigits;     // Some extra precision

    tx = d1.val;
    ty = d2.val;

    tx.prec (s);
    ty.prec (s);

    t = tx / ty;                    // Approximate division
    t = apfloat (apabsfloor (t.ap));

    a = abs (d1.val - t * d2.val);

    if (a >= b)                     // Fix division round-off error
        t += t.sign ();

    return t;
}

apint operator% (const apint &d1, const apint &d2)
{
    return fmod (d1.val, d2.val);
}
