
#include <math.h>

#include "fxtaux.h"


void 
dif2_fft0(double *fr, double *fi, int ldn, int is)
//
// dif-alg. cf. stoer/bulirsch p.83
// (de)scrambles data before exit
// i.e. loop is made with unscrambled data
//
// takes advantage of the fact that higher half of data is 0.0
//
{
    int    n2,m,m2,m21,j,r,t1,t2;
    double pi,phi,s,c;
    double ur,ui,vr,vi;

    n2=1<<ldn;

    pi=is*M_PI;  // +- pi


    m=ldn;   // ---------- LOOP 1 -----------------
    {
        m21=(1<<(m-1));       // m21=2^(m-1)
        m2=(m21<<1);          // m2=2^m

        phi=pi/(double)(m21);

        for (j=0; j<m21; ++j)
        {
              c=cos(ur=(phi*(double)j));
              s=sin(ur);

              {
                    t2=j+m21;
                    fr[t2]=(ur=fr[j])*c-(ui=fi[j])*s;
                    fi[t2]=ur*s+ui*c;
              }
        }

    }  // ------------------------------- end LOOP 1 ---------------


    for (m=ldn-1; m>=1; --m)   // ---------- LOOP -----------------
    {
        m21=(1<<(m-1));       // m21=2^(m-1)
        m2=(m21<<1);          // m2=2^m

        phi=pi/(double)(m21);

#if defined SANDE_USE_COS1SIN0
        j=0;
        {
            for (r=0; r<n2; r+=m2)     // use cos=1, sin=0
            {
                t1=r;        // index-help variables
                t2=t1+m21;

                ur=fr[t1];
                fr[t1]+=(vr=fr[t2]);
                ur-=vr;

                ui=fi[t1];
                fi[t1]+=(vi=fi[t2]);
                ui-=vi;

                fr[t2]=ur;
                fi[t2]=ui;
            }
        }

        for (j=1; j<m21; ++j)
#else
        for (j=0; j<m21; ++j)
#endif
        {
            sincos(&c,&s,phi*(double)j);  // sincos(...)

            for (r=0; r<n2; r+=m2)
            {
                t1=r+j;        // index-help variables
                t2=t1+m21;

                ur=fr[t1];
                fr[t1]+=(vr=fr[t2]);
                ur-=vr;

                ui=fi[t1];
                fi[t1]+=(vi=fi[t2]);
                ui-=vi;

                fr[t2]=ur*c-ui*s;
                fi[t2]=ur*s+ui*c;
            }
        }
    }  // ------------------------------- end LOOP ---------------


#if !defined NO_SCRAMBLE
    scramble(fr,fi,n2);            // rearrange function values
#endif

}
// ============================== end SANDE2_FFT0 ==========================
     

