
#include <math.h>

#include "fxtaux.h"


void 
dit2_fft(double *fr, double *fi, int ldn, int is)
//
// dit-alg. cf. stoer/bulirsch p.83 top
// scrambles data at entry
// i.e. loop is made with scrambled data
//
{
    int    n2,m,m2,m21,j,r;
    int    t1, t2;
    double pi,phi,c,s;
    double ur,vr, ui,vi;

    n2=1<<ldn;

    pi=is*M_PI;                      // +- pi

#if !defined NO_SCRAMBLE
    scramble(fr,fi,n2);                // rearrange function values
#endif

    for (m=1; m<=ldn; ++m)   // ---------- LOOP -----------------
    {
        m21=(1<<(m-1));       // m21=2^(m-1)
        m2=(m21<<1);          // m2=2^m

        phi=pi/(double)(m21);

#if defined COOLEY_USE_COS1SIN0
        j=0;                     // use cos=1, sin=0
        {
            for (r=0; r<n2; r+=m2)
            {
                t1=r;        // index-help variables
                t2=t1+m21;

                ur=fr[t1];
                fr[t1]+=(vr=fr[t2]);
                fr[t2]=ur-vr;

                ui=fi[t1];
                fi[t1]+=(vi=fi[t2]);
                fi[t2]=ui-vi;
            }
        }

        for (j=1; j<m21; ++j)
#else
        for (j=0; j<m21; ++j)
#endif
        {
            sincos(&c,&s,phi*(double)j);  // sincos(...)

            for (r=0; r<n2; r+=m2)
            {
                t1=r+j;        // index-help variables
                t2=t1+m21;

                vr=fr[t2]*c-fi[t2]*s;
                vi=fr[t2]*s+fi[t2]*c;

                ur=fr[t1];
                fr[t1]+=vr;
                fr[t2]=ur-vr;

                ui=fi[t1];
                fi[t1]+=vi;
                fi[t2]=ui-vi;
            }
        }
    }
} 
// ============================== end COOLEY2_FFT ==========================
