
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"


#define  FFT(f,g,ldn,is)   fht_fft(f,g,ldn,is)


void 
fft_complex_auto_convolution(double *f, double *g, ulong ldn)
//
// _cyclic_ (self-)convolution 
// (use zero padded data for usual conv.)
//
// f,g must not overlap
//
{
    const int is=1;
    const ulong n=(1<<ldn);

    FFT(f,g,ldn,is);

    for(ulong k=0; k<n; ++k)  csqr2(f[k],g[k]); 

    FFT(f,g,ldn,-is);

    d_multiply(f,n,1.0/n);
    d_multiply(g,n,1.0/n);
}
//=========================== end FFT_COMPLEX_AUTO_CONVOLUTION =================


void 
fft_complex_convolution(double *f, double *g, double *r, double *s, ulong ldn)
//
// _cyclic_ convolution 
// (use zero padded data for usual conv.)
//
// f,g,r,s must be pairwise non-overlapping
//
// result in r,s
// 
{
    assert( (f!=r) && (f!=s) );
    assert( (g!=r) && (g!=s) );

    const int is=1;
    const ulong n=(1<<ldn);

    FFT(f,g,ldn,is);
    FFT(r,s,ldn,is);

    for(ulong k=0; k<n; ++k)  cmult4(f[k],g[k],r[k],s[k]); 

    FFT(r,s,ldn,-is);

    d_multiply(r,n,1.0/n);
    d_multiply(s,n,1.0/n);
}
//=========================== end FFT_COMPLEX_CONVOLUTION =================


void 
fft_complex_auto_correlation(double *f, double *g, ulong ldn)
//
// _cyclic_ (self-)correlation 
// (use zero padded data for usual corr.)
//
// f,g must not overlap
//
{
    const int is=1;
    const ulong n=(1<<ldn);

    FFT(f,g,ldn,is);

    for(ulong k=0; k<n; ++k)  
    {
	f[k]*=f[k];
	f[k]+=g[k]*g[k];
	g[k]=0;
    } 

    FFT(f,g,ldn,-is);

    d_multiply(f,n,1.0/n);
    d_multiply(g,n,1.0/n);
}
//=========================== end FFT_COMPLEX_AUTO_CORRELATION =================



void 
fft_complex_correlation(double *f, double *g, double *r, double *s, ulong ldn)
//
// _cyclic_ correlation 
// (use zero padded data for usual conv.)
//
// f,g,r,s must be pairwise non-overlapping
//
// result in r,s
// 
{
    assert( (f!=r) && (f!=s) );
    assert( (g!=r) && (g!=s) );

    const int is=1;
    const ulong n=(1<<ldn);

    FFT(f,g,ldn,-is);
    FFT(r,s,ldn,is);

    for(ulong k=0; k<n; ++k)  cmult4(f[k],g[k],r[k],s[k]); 

    FFT(r,s,ldn,-is);

    d_multiply(r,n,1.0/n);
    d_multiply(s,n,1.0/n);
}
//=========================== end FFT_COMPLEX_CORRELATION =================

