
#include <iostream.h>
#include "jjassert.h"

#include "modm.h"

smod_t egcd_core(smod_t u, smod_t v, smod_t &u1, smod_t &u2);

umod_t
gcd(umod_t a, umod_t b)
{
    umod_t d;

    if ( a==0 )
    {
	d = b;
    }
    else
    {
	if ( b==0 )  d = a;
	else
	{
	    umod_t r;

	    do
	    {
		r = a%b;
		a = b;
		b = r;
	    }
	    while ( r!=0 );

	    d = a;
	}
    }

    return d;
}
// ============= end GCD ===========


umod_t
lcm(umod_t a, umod_t b)
{
    return (a*b)/gcd(a,b);
}
// ============= end LCM ===========


/*
umod_t
u_egcd(umod_t u, umod_t v, umod_t &u1, umod_t &u2)
{

#if  ( ! USE_LEQ_63BIT_MODULUS )
#error " umod_t egcd() will fail. "
#endif

    smod_t us = u;
    jjassert( us>=0 );
    smod_t vs = v;
    jjassert( vs>=0 );
    smod_t u1s, u2s;

    smod_t rs = egcd_core( us, vs, u1s, u2s );

    // u*u1+v*u2==r
    jjassert( us*u1s+vs*u2s==rs );

    return (umod_t)rs;
}
// ============= end U_EGCD ===========
*/


smod_t
egcd(smod_t u, smod_t v, smod_t &u1, smod_t &u2)
{
    smod_t r = egcd_core(u,v,u1,u2);
    return r;
}
// ============= end EGCD ===========


#define  EGCD_CHECK  1  // set to 0 or 1
#if  ( EGCD_CHECK )
#else
#warning  " egcd is not checked "
#error    " do not use: zamzink ist ronk ! "
#endif // ( EGCD_CHECK )


smod_t
egcd_core(smod_t u, smod_t v, smod_t &u1, smod_t &u2)
//
// return u3 and set u1,v1 so that
//   u3 == u*u1+v*u2
//
// cf. knuth2, p.325
{
    smod_t v1=0;
    smod_t v3=v;

    u1=1;
    u2=0;
    smod_t u3=u;


#if  ( EGCD_CHECK )
    smod_t v2=1; 
    jjassert( u*u1+v*u2==u3 );
    jjassert( u*v1+v*v2==v3 );
#endif // ( EGCD_CHECK )

    while ( v3!=0 )
    {
        smod_t q = u3/v3;

        smod_t t1 = u1-v1*q;
        u1 = v1;
        v1 = t1;

        smod_t t3 = u3-v3*q; // u3%v3
        u3 = v3;
        v3 = t3;

#if  ( EGCD_CHECK )
        smod_t t2 = u2-v2*q;   //2
        u2 = v2;  //2
        v2 = t2;  //2

        jjassert( u*t1+v*t2==t3 );
        jjassert( u*u1+v*u2==u3 );
        jjassert( u*v1+v*v2==v3 );
#endif // ( EGCD_CHECK )
    }


#if  ( EGCD_CHECK )
    jjassert( (umod_t)u3==gcd(u,v) );

//    cout << "\n  u2= " << u2;
//    cout << "\n  u= " << u;
//    cout << "\n  u1= " << u1;
//    cout << "\n  u*u1= " << u*u1;
//    cout << "\n  u3= " << u3;
//    cout << "\n  u3-u*u1= " << u3-u*u1;
//    cout << "\n  v= " << v;
//    cout << "\n  u2:=(u3-u*u1)/v= " << (u3-u*u1)/v;
#else
    u2 = (u3-u*u1)/v;
#endif // ( EGCD_CHECK )


    jjassert( u*u1+v*u2==u3 );

    return u3;
}
// ============= end EGCD ===========

