#if !defined __PFAFFT_H
#define      __PFAFFT_H

#include <complex.h>
#if defined __COMPLEXT__
#define Complex complex<double>
#endif

// pfafft.cc:
int npfa (int nmin);
int npfao (int nmin, int nmax);
int npfar (int nmin);
int npfaro (int nmin, int nmax);

void pfacc (int isign, int n, Complex z[]);
void pfacr (int isign, int n, Complex cz[], double rz[]);
void pfarc (int isign, int n, double rz[], Complex cz[]);
void pfamcc (int isign, int n, int nt, int k, int kt, Complex z[]);

void pfa2cc (int isign, int idim, int n1, int n2, Complex z[]);
void pfa2cr (int isign, int idim, int n1, int n2, Complex cz[], double rz[]);
void pfa2rc (int isign, int idim, int n1, int n2, double rz[], Complex cz[]);


#endif // !defined __PFAFFT_H
