#include <math.h>
#include <std.h>
#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"



#define VARIANT_AGM 1


int log2(long n, hfloat &l)
{
    int k;
    hfloat a(n),b(n),c(n),d(n);


#if  ( VARIANT_AGM == 1 )

    isqrt(2,b);
    log(b,c);
    mul(c,-2,d); 
    cout << "\n\n log(2)=\n";
    print("\n logarithm=\n",d);

#else

    //
    // == \sum_{k=0}^{\infty}{1/((2*k+1)*3^(2*k+1))}
    //

    int kmax;

    kmax=(int)((n*log((double)a.radix())/log(3.0)-1.0)/2.0)+2;

    cout << "\n adding " << kmax+1 << " terms ... \n";

    start_timer();

    a = 1;
    b = 3;
    d = 0;

    for(k=0; k<=kmax; k++)
    {
        div(a,2*k+1,c);   // 1/(2k-1) 
        div(b,9,b);       // 1/3^(2k+1)
        mul(c,b,c);       //
        add(c,d,d);       // add up
    } 

    mul(d,2,d);

    cout << "\n elapsed time=" << return_elapsed_time() << " seconds ";

    print("\n log(2)= \n", d);

#endif // ( VARIANT_AGM == 1 )

    l = d;

    return 0;
}


