#include <math.h>
#include <assert.h>
//#include <stdio.h>
#include <iostream.h>

#include "mybuiltin.h"
#include "auxid.h"
#include "hfloatfu.h"
#include "workspc.h"
#include "auxk.h"



int mass_carry(FILE *ifile, long n, LIMB *res, long resprec)
//
//  mass storage carry
//
{
long    ret;
long    wct;
long    wramsz,v;
long    resi;  // index for res
size_t   pf;
double   cy;
double   *pwr;


    pwr=(double *)gws.get_ws0(); 

    wramsz=hfg_wsdbls/4;

    if(wramsz>n/2)
       wramsz=n/2;

    v=n/wramsz;
     
    pf=n-wramsz;
    resi=n-wramsz;
    cy=0.0;
    for(wct=0; wct<v; ++wct,pf-=wramsz,resi-=wramsz)
    {
        kd_copy(ifile,pf,pwr,wramsz);

        carry_thru(pwr,wramsz,cy);

        if(resprec>=resi+wramsz)
	{
           di_copy(pwr,wramsz,res+resi,MIN(wramsz,resprec));
	}
        else 
        { 
	}
    }


    if(cy!=0)
    {
        ret=1;
        i_carry_adj(res,resprec,cy);
    }
    else
    {
        ret=0;
    } 

    fclose(ifile);

    gws.let_ws0();

return ret;
} 
/*===================== end MASS_CARRY =========================*/
