
#include <math.h>
#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "mybuiltin.h"
#include "verbose.h"


#define PR(x)     // for debug
#define SHRT 10   // prec for print


int fxt_mul_special(const hfloat &ai, const hfloat &bi, hfloat &c)
//
// multiplies that can't be done in one piece
//
// uses (a+b)^2-(a-b)^2 = 4*a*b
//
{
    int ae,be,ce;
//cerr<<"\n MMM c.prec()="<<c.prec()<<endl;
    hfloat accu(c.prec());
    hfloat a(ai.prec()), b(bi.prec());

    PR( cout.form("\n -------- mult_spec: %d %d %d ",a.prec(),b.prec(),c.prec()); )
    PR( print("\n mult_spec: a[]= \n",a,SHRT); )
    PR( print("\n mult_spec: b[]= \n",b,SHRT); )

    verbose(1," X[");

//assert(0); // FORBIDDEN


//    clone_hfloat(ai,a);
//    clone_hfloat(bi,b);
    a=ai;
    b=bi;

// avoid loss of precision due to cancellation in add or sub:
    ae=a.exp(); a.exp(0);
    be=b.exp(); b.exp(0);

    sub(a,b,accu);
    PR( print("\n mult_spec: a-b= \n",accu,SHRT); )

    PR( check_hfloat(" a ",a); ) 
    PR( check_hfloat(" b ",b); )
    PR( check_hfloat(" accu ",accu); )

    PR( cout<<"\n calls ("<<accu.prec()<<")"; )

    if(accu.prec()>=hfg_sqr_special_thres)        // (a-b)^2
        fxt_sqr_special(accu,accu);   
    else
        fxt_sqr(accu,accu);

    PR( print("\n mult_spec: (a-b)^2= \n",accu,SHRT); )

    add(a,b,c);
    PR( print("\n mult_spec: (a+b)= \n",c,SHRT); )

    PR( cout<<"\n calls ("<<c.prec()<<")"; )

    if(c.prec()>=hfg_sqr_special_thres)        // (a+b)^2
        fxt_sqr_special(c,c);   
    else
        fxt_sqr(c,c);

    PR( print("\n mult_spec: (a+b)^2= \n",c,SHRT); )

    sub(c,accu,c);
    PR( print("\n mult_spec: (a+b)^2-(a-b)^2 = \n",c,SHRT); )

    div(c,4,c);               // a*b
    PR( print("\n mult_spec: ((a+b)^2-(a-b)^2)/4 = \n",c,SHRT); )

    PR( fflush(stdout); )

// following allows for a or b beeing the same as c:
    ce=c.exp();
    a.exp(ae); 
    b.exp(be);
    c.exp(ce+ae+be);

    verbose(1,"] ");

//    a.digit=NULL;
//    b.digit=NULL;

    return c.sign();
}
//====================== end FXT_MULTIPLY_SPECIAL =======================

