
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"
#include "radix.h"
#include "verbose.h"


#define PR  if(0)


int raw_div_short(LIMB *a, int b, LIMB *c, long n)
//
// c=a/b
//
// returns rem
//
{
    unsigned zz,rem;
    long  k;

    assert(b>=0);

    rem=0;

    if(a!=c)              // c=a/b
    {
        for(k=0; k<n; ++k)           // high to low
        {
            zz=(unsigned int)a[k]+RADIX_TIMES(rem);
            c[k]=(LIMB)(zz/b);
            rem=zz%b;
        }
    }
    else                              // c/=b
    {
        for(k=0; k<n; ++k)           // high to low
        {
            zz=(unsigned int)c[k]+RADIX_TIMES(rem);
            c[k]=(LIMB)(zz/b);
            rem=zz%b;
        }
    }

    return rem;
}
//================== end RAW_DIVIDE_SHORT ========================

