
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"
#include "mybuiltin.h"
#include "radix.h"

#define PR  if(0)


int raw_mul_short(LIMB *a, int b, LIMB *c, long n)
//
// c=a*b (or c*=b)
//
// must be: b < RADIX !!!
//
// must be ?? length(c) == length(a) !
//
// return: last carry
//
{
    int an;
    unsigned zz,cy;
    long k;

    assert(b>=0);
    assert(b<RADIX);

    an=n;

    cy=0;

    if(a!=c)
    {
        for(k=an-1; /*k>=0*/ ; --k)           // low to high
        {
            zz=(unsigned int)a[k]*b+cy;
            c[k]=IMODRAD(zz);
            cy=IDIVRAD(zz);
            if(k==0)
                break;
        }
    }
    else                                 // c*=b
    {
        for(k=an-1; /*k>=0*/ ; --k)           // low to high
        {
            zz=(unsigned int)c[k]*b+cy;
            c[k]=IMODRAD(zz);
            cy=IDIVRAD(zz);
            if(k==0)
                break;
        }
    }


return cy;
}
//=============== end RAW_MULTIPLY_SHORT ==================


