
//#include <iostream.h>
#include <assert.h>

#include "hfdata.h"


#define SMALL_DBL (1.0e-23)
#define LARGE_DBL (1.0e+23)

//#define HUGE_EXP  307
//#define HUGE_DBL  (1.0e+307)



int
dt_mantissa_to_double(const hfdata &a, ulong prec, double &b)
//
// resulting double is < 1.0
//
{
    LIMB *ad = a.dig();
    const double drx1 = 1.0/(double)hfdata::rx;

    b = 0.0;
    double f = 1.0;
    for (ulong k=0; k<prec; ++k)  // add up the LIMBs
    {
        f *= drx1;
        if ( f<SMALL_DBL )  break;
        b +=  ad[k]*f;
    }

    return 0;
}
//=============== end DT_MANTISSA_TO_DOUBLE =======================


ulong
dt_double_to_mantissa(double d, ulong prec, hfdata &a)
//
// double d must be < 1.0
//
{
    assert( d<1.0 );

    LIMB *ad = a.dig();
    const double drx = (double)hfdata::rx;
    const double drx1 = 1.0/(double)hfdata::rx;

    //    i_null(ad,prec);
    a.fill(0,prec,0);

    double  f = 1.0;
    ulong  k;
    for (k=0; k<prec; ++k)
    {
        f *= drx1;
        if ( f<SMALL_DBL )  break;
        //        cout << " fff=" << f;

        d *= drx;
        //        cout << "  ddd=" << d << endl;

        ad[k] = (LIMB)d;
        d -= ad[k];
    }

    return k;
}
//===================== end DT_DOUBLE_TO_MANTISSA =======================
