
#include <assert.h>

#include "auxid.h"
#include "mybuiltin.h"


//#define NO_OVERLAP(x,xn,y,yn) ( (ABS(x-y)>=xn) && (ABS(x-y)>=yn) )


int i_add(const LIMB *a, ulong an, const LIMB *b, ulong bn,
          LIMB *c, ulong cn, const unsigned rx)
//
// c[] = a[] + b[]  (incl. radix rx carry)
// returns last carry
//
{
    const LIMB *x;
    ulong xn;

    if ( a==c )
    {
	x = b;
	xn = bn;
    }
    else
    {
        if ( b!=c ) 
        {
            i_copy(b,bn,c,cn);
        }

        x = a;
        xn = an;
    }


    const ulong m = MIN(xn,cn);
    unsigned cy = 0;
    for (ulong k=m-1;   ; --k)
    {
        unsigned r = c[k]+x[k]+cy;

        if ( r>=rx )
        {
	    r -= rx;
            cy = 1;
        }
        else
        {
            cy = 0;
        }

	c[k] = (LIMB)r;

	if ( k==0 )  break;
    }

    return cy;
}
//===================== end I_ADD =====================


int
i_sub(const LIMB *a, ulong an, const LIMB *b, ulong bn,
      LIMB *c, ulong cn, const unsigned rx)
//
// c[] = a[] - b[]   (incl. radix rx borrow)
// returns last borrow
//
{
    int bw;

    if ( b!=c )
    {
        i_copy(a,an,c,cn);

        ulong i = MIN(bn,cn);
        bw = 0;
        for (ulong k=i-1;   ; --k)
        {
            int r = c[k]-b[k]-bw;

            if ( r<0 )
            {
                r += rx;
                bw = 1;
            }
            else
            {
                bw = 0;
            }

            c[k] = (LIMB)r;

            if ( k==0 )  break;
        }
    }
    else  // b==c
    {
        for (ulong k=cn-1; k>=bn; --k)  c[k] = 0;

        ulong i = MIN(an,cn);
        bw = 0;
        for (ulong k=i-1;   ; --k)
        {
            int r = a[k]-c[k]-bw;

            if ( r<0 )
            {
                r += rx;
                bw = 1;
            }
            else
            {
                bw = 0;
            }

            c[k] = (LIMB)r;

            if ( k==0 )  break;
        }
    }

    return bw;
}
//====================== end I_SUB =====================

