
#include <math.h>

#define u   (2.0*M_PI/9.0)
#define cu1 ((2.0*cos(u)-cos(2.0*u)-cos(4.0*u))/3.0)
#define cu2 ((cos(u)+cos(2.0*u)-2.0*cos(4.0*u))/3.0)
#define cu3 ((cos(u)-2.0*cos(2.0*u)+cos(4.0*u))/3.0)

#define s1u (sin(u))
#define s2u (sin(2.0*u))
#define s3u (sin(3.0*u))
#define s4u (sin(4.0*u))


#define SWAP(x,y)  {double t=x; x=y; y=t;}

#define UU (1.0)

// XXX UNTESTED !

void 
fft9(double *xr, double *xi)
//
// cf. nussbaumer p.148f
//
{
    // --- RE:
    double tr1,tr2,tr3,tr4,tr5,tr6,tr7,tr8,tr9,tr10,tr11,tr12,tr13,tr14;

    tr1= xr[1]+xr[8];
    tr6= xr[1]-xr[8];
 
    tr2= xr[7]+xr[2];
    tr7= xr[7]-xr[2];
 
    tr3= xr[3]+xr[6];
    tr8= xr[3]-xr[6]; 
 
    tr4= xr[4]+xr[5];
    tr9= xr[4]-xr[5];


    tr5=  tr1+tr4+tr2;
    //    tr12= tr2-tr4;
 
    tr14= tr7-tr9;
    tr10= tr7+tr9+tr6;
    tr13= tr7-tr6;
 
    tr11= tr1-tr2;
    tr12= tr2-tr4;


    double mr0,mr1,mr2,mr3,mr4,mr5, tr15,tr16;

    mr0= xr[0]+tr3+tr5;
    mr1= UU*(2.0/3)*tr3;
    mr2= -0.5*tr5;

    tr15= -tr12-tr11;
    tr16=  tr14-tr13;

    mr3= cu1*tr11;
    mr4= cu2*tr12;
    mr5= cu3*tr15;


    // --- IM:
    double ti1,ti2,ti3,ti4,ti5,ti6,ti7,ti8,ti9,ti10,ti11,ti12,ti13,ti14;

    ti1= xi[1]+xi[8];
    ti6= xi[1]-xi[8];
 
    ti2= xi[7]+xi[2];
    ti7= xi[7]-xi[2];
 
    ti3= xi[3]+xi[6];
    ti8= xi[3]-xi[6];
 
    ti4= xi[4]+xi[5];
    ti9= xi[4]-xi[5];

    ti5=  ti1+ti4+ti2;
    //    ti12= ti2-ti4;
 
    ti14= ti7-ti9;
    ti10= ti7+ti9+ti6;
    ti13= ti7-ti6;
 
    ti11= ti1-ti2;
    ti12= ti2-ti4;


    double mi0,mi1,mi2,mi3,mi4,mi5, ti15,ti16;

    mi0=  xi[0]+ti3+ti5;
    mi1=  (2.0/3)*ti3;
    mi2= -0.5*ti5;

    ti15= -ti12-ti11;
    ti16=  ti14-ti13;

    mi3= cu1*ti11;
    mi4= cu2*ti12;
    mi5= cu3*ti15;


    // RE, IM:  ------------------

    double mr6,mr7,mr8,mr9,mr10;
    double mi6,mi7,mi8,mi9,mi10;

    mr6=  s3u*ti10;
    mi6= -s3u*tr10;

    mr7=  s3u*ti8;
    mi7= -s3u*tr8;

    mr8= -s1u*ti13;
    mi8=  s1u*tr13;

    mr9= -s4u*ti14;
    mi9=  s4u*tr14;

    mr10= -s2u*ti16;
    mi10=  s2u*tr16;

    // --------------------------


    // RE:

    double tr0;
    tr0= -mr3-mr4;
    tr1=  mr5-mr4;
    tr2= -mr8-mr9;
    tr3=  mr9-mr10;
    tr4=  mr0+mr2+mr2;  // !
    tr5=  tr4-mr1;
    tr6=  tr4+mr2;
    tr7=  tr5-tr0;
    tr8=  tr1+tr5;
    tr9=  tr0-tr1+tr5;
    tr10= mr7-tr2;
    tr11= mr7-tr3;
    tr12= mr7+tr2+tr3;


    xr[0]= mr0;

    xr[1]= tr7+tr10;
    xr[8]= tr7-tr10;
 
    xr[7]= tr8+tr11;
    xr[2]= tr8-tr11;
 
    xr[3]= tr6+mr6;
    xr[6]= tr6-mr6;
 
    xr[4]= tr9+tr12;
    xr[5]= tr9-tr12;


    // IM:

    double ti0;
    ti0= -mi3-mi4;
    ti1=  mi5-mi4;
    ti2= -mi8-mi9;
    ti3=  mi9-mi10;
    ti4=  mi0+mi2+mi2;  // !
    ti5=  ti4-mi1;
    ti6=  ti4+mi2;
    ti7=  ti5-ti0;
    ti8=  ti1+ti5;
    ti9=  ti0-ti1+ti5;
    ti10= mi7-ti2;
    ti11= mi7-ti3;
    ti12= mi7+ti2+ti3;


    xi[0]= mi0;
 
    xi[1]= ti7+ti10;
    xi[8]= ti7-ti10;
 
    xi[7]= ti8+ti11;
    xi[2]= ti8-ti11;
 
    xi[3]= ti6+mi6;
    xi[6]= ti6-mi6;
 
    xi[4]= ti9+ti12;
    xi[5]= ti9-ti12;

}

