#include <math.h>

#include "fxtaux.h"
#include "fxt.h"


void 
make_fft_chirp(double *wr, double *wi, ulong n, ulong nn, int is)
{
    ulong k,np,nd;

    nd=2*n;
    const double phi=is*1.0*M_PI/n;

    for(k=0 ; k<nn; ++k)  wr[k]=wi[k]=0.0;

    for(np=0,k=0; k<n; ++k)
    {
        double c,s;

//        n2=(double)k*k;
//        sincos(&c,&s,phi*n2);  
//  possible loss of precision due to huge arguments in sincos 

        sincos(&c,&s,phi*np);

        np+=((k<<1)+1);

        if(np>=nd)  np-=nd;

        wr[k]=c;
        wi[k]=s;
    }
}
/* ============== end MAKE_FFT_CHIRP ================ */


void 
complete_fft_chirp(double *wr, double *wi, ulong n, ulong nn)
{
    ulong k;

    if(n&1)  // n odd
    {
	for(k=n; k<nn; ++k)
	{
	    wr[k]=-wr[k-n];
	    wi[k]=-wi[k-n];
	}
    }
    else
    {
	for(k=n; k<nn; ++k)
	{
	    wr[k]=wr[k-n];
	    wi[k]=wi[k-n];
	}
    }
}
/* ============== end COMPLETE_FFT_CHIRP ================ */



void 
chirp_fft(double *x, double *y, ulong n, int is)
//
// arbitrary length fft
//
// use n*k == n^2/2 + k^2/2 + -(k-n)^2/2
// (see: nussbaumer: FFT and convolution algorithms 5.1)
// ( could use n*k == -n^2/2 + -k^2/2 + (k+n)^2/2 instead )
// ( ?? n*k == (n+k)^2/4 + -(n-k)^2/4 )
//
// nn is the smallest power of 2 >=2*n
//
// worst case if n=2^x+1:
//   then work is about 12 times a fft of length 2^x
//   and allocated workspace =4*2^x
//
{
    ulong k,nn,ldn;
    double *wr,*wi,*fr,*fi;

    ldn=ld(n);

    if( n==((ulong)1<<ldn) )  ldn+=1;
    else                      ldn+=2;

    nn=(1<<ldn);

    fr=new double[nn];
    fi=new double[nn];

    d_copy(x,fr,n); 
    d_null(fr+n,nn-n);
    d_copy(y,fi,n); 
    d_null(fi+n,nn-n);


    wr=new double[nn];
    wi=new double[nn];


    make_fft_chirp(wr,wi,n,nn,is);

    for(k=0; k<n; ++k)  cmult4(wr[k],wi[k],fr[k],fi[k]);    

    for(k=0; k<n; ++k)  wi[k]=-wi[k];
 
    complete_fft_chirp(wr,wi,n,nn);

    fft_complex_convolution(wr,wi,fr,fi,ldn);

    make_fft_chirp(wr,wi,n,nn,is);

    complete_fft_chirp(wr,wi,n,nn);

    for(k=0; k<nn; ++k)  cmult4(fr[k],fi[k],wr[k],wi[k]);    


    d_copy(wr+n,x,n); 
    d_copy(wi+n,y,n); 

    delete [] wr;
    delete [] wi;

    delete [] fr;
    delete [] fi;

    return;
}
/* ============== end CHIRP_FFT ================ */
