
#include <math.h>

#include "fxtaux.h"


void 
dif2l_fft(double *fr, double *fi, ulong ldn, int is)
//
// dif-tukey-alg. cf. stoer/bulirsch p.83
// (de)scrambles data before exit
// i.e. loop is made with unscrambled data
//
{
    const ulong n=(1<<ldn);

    const double pi=is*M_PI;  // +- pi

    for(ulong ldm=ldn; ldm>=1; --ldm)
    {
        const ulong m=(1<<ldm);            // m=2^ldm
	const ulong mh=(m>>1);             // mh=m/2

        const double phi=pi/(double)(mh);

        for(ulong j=0; j<mh; ++j)
        {
	    double s,c;
            sincos(&c,&s,phi*(double)j);  // sincos(...)

            for (ulong r=0; r<n; r+=m)
            {
		// u=f[t1]
		// v=f[t2]
		// f[t1]= u+v
		// f[t2]= (u-v)*exp(+-2*pi*i*j/m)

                const ulong t1=r+j;        // index-help variables
                const ulong t2=t1+mh;

                double ur=fr[t1];
		double vr=fr[t2];
                fr[t1] += vr;
                ur -= vr;

                double ui=fi[t1];
		double vi=fi[t2];
                fi[t1] += vi;
                ui -= vi;

                fr[t2]=ur*c-ui*s;
                fi[t2]=ur*s+ui*c;
            }
        }
    }

    scramble(fr,fi,n);            // rearrange function values
}
// ============================== end SANDE2L_FFT ==========================
