
#include "fxt.h"
#include "fxtaux.h"


void
fht_auto_convolution(double *x, ulong ldn)
{
    fht(x,ldn);

    fht_auto_convolution_core(x,ldn);

    fht(x,ldn);
}
// ================ end FHT_AUTO_CONVOLUTION ==============


void
fht_auto_convolution0(double *x, ulong ldn)
{
    fht0(x,ldn);

    fht_auto_convolution_core(x,ldn);

    fht(x,ldn);
}
// ================ end FHT_AUTO_CONVOLUTION0 ==============



void
fht_auto_convolution0_2proc(double *f, ulong ldn)
{
    const ulong n=(1<<ldn);
    const ulong nh=(n>>1);
    ulong ldnh=ldn-1;

    double *g=f+nh;
    d_copy(f,g,nh);


    // ----- processor 1:
    fht(f,ldnh);
    fht_auto_convolution_core(f,ldnh);
    fht(f,ldnh);
    // ----- end proc1


    // ----- processor 2:
    cos_revsin(g,nh);
    fht(g,ldnh);
    fht_auto_convolution_core_x(g,ldnh);
    fht(g,ldnh);
    cos_revsin(g,nh);
    // ----- end proc2


    d_sumdiff_05(f,g,nh);
}
//============= end FHT_AUTO_CONVOLUTION0_2PROC ============



void
fht_auto_convolution_core(double *x, ulong ldn)
{
    //    normalize  done (with dn) !

    const ulong   n = (1<<ldn);
    const ulong  nh = n/2;
    const double dn = (0.5/n);

    for (ulong i=1,j=n-1; i<nh; i++,j--)
    {
        double a = x[i];
        double b = x[j];

        double s1=(a+b)*(a-b);

        a *= b;
        a += a;

        x[i] = dn*(a+s1);  // 1/2/n*( 2ab+a^2-b^2 )
        x[j] = dn*(a-s1);  // 1/2/n*( 2ab-a^2+b^2 )
    }

    x[0]  *= 2.0*dn*x[0];
    x[nh] *= 2.0*dn*x[nh];
}
// ================ end FHT_AUTO_CONVOLUTION_CORE ==============



void
fht_auto_convolution_core_x(double *x, ulong ldn)
{
    //    normalize  done (with dn) !

    const ulong   n = (1<<ldn);
    const ulong  nh = n/2;
    const double dn = (0.5/n);

    for (ulong i=0,j=n-1; i<nh; i++,j--)
    {
        double a = x[i];
        double b = x[j];

        double s1 = (a+b)*(a-b);

        a *= b;
        a += a;

        x[i] = dn*(a+s1);  // 1/2/n*( 2ab+a^2-b^2 )
        x[j] = dn*(a-s1);  // 1/2/n*( 2ab-a^2+b^2 )
    }
}
// ================ end FHT_AUTO_CONVOLUTION_CORE_X ==============




void
cos_revsin(double *a, ulong n)
{
    const ulong nh = (n>>1);

    const double ph0 = M_PI/n;
    for(ulong i=1, j=n-1; i<nh; ++i,--j)
    {
	double phi,s,c;

	phi = ph0*i;
	sincos(&c,&s,phi);

	double ai,aj;
	ai = a[i]*c+a[j]*s;
	aj = a[i]*s-a[j]*c;

	a[i] = ai;
	a[j] = aj;
    }
}
// =========== end COS_REVSIN  ===========

