#if !defined __MOD_H
#define      __MOD_H


#include <iostream.h>
#include <assert.h>
#include <math.h>

#include "mtypes.h"
#include "modarith.h"
#include "factor.h"


// the class 'mod_init' has the sole purpose
// of initialising the class 'mod'

class mod_init
{
public:
    mod_init(umod_t, umod_t *facts);
    ~mod_init();
};
//--------------------------


class mod
{
public:

    mod()  {};
    ~mod()  {};

    mod(const mod &m)  { x = m.x; }
    mod & mod::operator = (const mod &h)  { x = h.x; return *this; }

//    mod(const smod_t i)  { x = s_set_mod_mod(i); }
    mod(const umod_t i)  { x = u_set_mod_mod(i); }
//    mod & mod::operator = (smod_t i)  { (*this) = mod(i); return *this; }
    mod & mod::operator = (umod_t i)  { (*this) = mod(i); return *this; }

//    mod(int i)   { (*this) = (mod)(smod_t)i; }
//    mod(uint i)  { (*this) = (mod)(umod_t)i; }
//    mod & mod::operator = (int i)   { (*this) = mod(i); return *this; }
    mod & mod::operator = (uint i)  { (*this) = mod(i); return *this; }

#if  ( USE_64BIT_MOD_T )
//    mod(long i)   { (*this) = (mod)(smod_t)i; }
//    mod(ulong i)  { (*this) = (mod)(umod_t)i; }
//    mod & mod::operator = (long i)   { (*this) = mod(i); return *this; }
    mod & mod::operator = (ulong i)  { (*this) = mod(i); return *this; }
#endif

    friend mod & operator += (mod &z, const mod &h)
    { z.x = add_mod_mod(z.x,h.x); return z; }

    friend mod & operator -= (mod &z, const mod &h)
    { z.x = sub_mod_mod(z.x,h.x); return z; }

    friend mod & operator *= (mod &z, const mod &h)
    { z.x = mul_mod_mod(z.x,h.x); return z; }

    friend mod & operator /= (mod &z, const mod &h)
    { mod inv(const mod&); z = inv(h); return z; }


    friend const mod operator + (const mod &h1, const mod &h2)
    { mod z(h1); z += h2; return z; }

    friend const mod operator - (const mod &h1, const mod &h2)
    { mod z(h1); z -= h2; return z; }

    friend const mod operator * (const mod &h1, const mod &h2)
    { mod z(h1); z *= h2; return z; }

    friend const mod operator / (const mod &h1, const mod &h2)
    { mod inv(const mod&); mod h3 = inv(h2); h3 *= h1; return h3; }


    friend const int operator == (const mod &h1, const mod &h2)
    { return  h1.x == h2.x; }

    friend const int operator != (const mod &h1, const mod &h2)
    { return  h1.x != h2.x; }


    // --- IMPLEMENTATION:
    umod_t x;


    // --- STATIC:
    static umod_t modulus;        // 0 <= x < modulus 
    static factorization mfact;   // factorization of modulus

    static double  mbitsd;        // log_2(modulus)
    static uint    mbits;         // ceil(mbitsd) = how many bits modulus uses
    static long double m1dd;      // 1.0/modulus (needed for multiplication)

    static umod_t maxorder;       // maximal order of elements
    static factorization xfact;   // factorization of maxorder
    static uint    max2pow;  // exponent of 2 in factorisation of maxorder
    // ==> fft length max 2^(ldmax2pow) if restricted to powers of 2

    static umod_t phi;            // phi(modulus)
    // == modulus-1 for prime modulus
    static factorization pfact;   // factorization of phi

    static mod  zero;             // = 0
    static mod  one;              // = 1
    static mod  minus_one;        // = -1 == mod(modulus-1)
    static mod  primroot;         // element of maximal order
    static mod  inverse_primroot; // inverse of primroot

    static mod  root2pow(int ldorder)  // root of order 2^ldorder
    {
        assert( ldorder<= (int)max2pow );
        assert( ldorder>=-(int)max2pow );
        if ( ldorder>=0 )  return root_2pow[ldorder];
        else               return invroot_2pow[-ldorder];
    }

    static int modulus_prime() { return  (mfact.prime[0]==modulus); }

    static int modulus_cyclic()
    {
        if ( 1==mfact.npr )  return 1;  // prime (power) modulus

        if ( (2==mfact.npr) && mfact.has_prime_factor(2) )
            return 1;  // 2 * prime (power) modulus

        return 0;
    }

//private:
    static mod * root_2pow; //[max2pow+1];      // element[k] is of order 2^k
    static mod * invroot_2pow; //[max2pow+1];   // element[k] is of order 2^-k

    /*
    // --- Montgomery section: (currently unused)
    static ulong  mg_bits;       // Montgomery ld(R)
    static umod_t mg_mask;       // Montgomery R-1

    static umod_t mg_r;          // Montgomery R mod m
    static umod_t mg_r_prime;    // Montgomery R^-1 mod m
    static umod_t mg_m;          // Montgomery modulus
    static umod_t mg_m_prime;    // Montgomery -modulus^-1 mod R
    */

    // magic initialiser:
    // (MUST be initialized after all other static stuff!)
    // cf. modinit.cc
    static mod_init *mod_initializer;
};
//---------------------------------------------


inline double
make_double(const mod &h)
{
    double d;
    d = (double)(h.x);
//    assert( mod_t(d)==h.x );
    return d;
}

inline mod
make_mod(const double &d)
{
    mod m; 
    m.x = (umod_t)floor(d+0.5);
//    assert( double(m.x)==d );
    return  m;
}

/*
inline mod
mod::root2pow(int ldorder)
{
    if ( ldorder>=0 )  return root_2pow[ldorder];
    else               return invroot_2pow[-ldorder];
}
*/

inline mod operator + (const mod &h)
{ mod p; p.x = h.x; return p; }

inline mod operator - (const mod &h)
{ mod n; n.x = (mod::modulus)-h.x; return n; }


inline istream&  operator >> (istream& is, mod& h)
{ is >> h.x; return is; }

inline ostream&  operator << (ostream& os, const mod& h)
{ os << h.x; return os; }


// modfuncs.cc:
umod_t order(mod x);
umod_t find_maxorder();
umod_t find_maxorder_element();
umod_t find_primitive_root();
int is_primitive_root(mod r);

mod div(const mod& m1, const mod& m2);
mod inv(const mod& m);
mod pow(const mod& a, umod_t ex);
mod invpow(const mod& a, umod_t ex);
mod root(umod_t);
mod invroot(umod_t);


// order.cc:
umod_t order_mod(umod_t x, umod_t m, const factorization &phifact);


// primroot.cc:
umod_t find_maxorder_mod(const factorization &mf);
umod_t find_maxorder_element_mod(const factorization &mf, umod_t mx, const factorization &pf);
int is_primitive_root_mod(umod_t r, umod_t m, const factorization &pf);
umod_t find_primitive_root_mod(umod_t m, const factorization &pf);



// sqrtmod.cc:
umod_t sqrt(umod_t a);


inline void
add(const mod& m1, const mod& m2, mod& r)
{ r.x = add_mod_mod(m1.x,m2.x); }

inline void
sub(const mod& m1, const mod& m2, mod& r)
{ r.x = sub_mod_mod(m1.x,m2.x); }

inline void
mul(const mod& m1, const mod& m2, mod& r)
{ r.x = mul_mod_mod(m1.x,m2.x); }

inline void
sqr(const mod& m, mod& r)
{ r.x = mul_mod_mod(m.x,m.x); }



// modinfo.cc:
void mod_info();
void mod_info1();
void mod_info2();
void mod_info3();
void mod_info4();
void mod_info99();


// modm.cc:
void fill(mod *dst, ulong n, mod src);
void copy(const mod *src, mod *dst, ulong n);
void multiply(mod *f, ulong n, mod m);
void print(char *bla, const mod *f, ulong n);
ulong diff_print(mod *f, mod *g, ulong n, int supreq=1);
ulong diff_print(double *f, double *g, ulong n);
ulong diff(mod *src, mod *dst, ulong n);
void bogo_rand(mod *f, ulong n, umod_t m);
void bogo_rand(double *f, ulong n, umod_t m);
void copy(const double *src, double *dst, ulong n);


#endif  // !defined __MOD_H
