
#include "fxtaux.h"
#include "fxt.h"


#define FFT(re,im,n,is)  fht_fft(re,im,ld(n),is)
#define FFT0(re,im,n,is)  fht_fft0(re,im,ld(n),is)

void 
wide_fft(double *fr, double *fi, ulong n, ulong d, double *wr, double *wi, int is)
//
// compute fft of the n elements 
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong k,j;

    for(k=0,j=0; k<n*d; k+=d,j++)  // fill workspace
    {
        wr[j]=fr[k];
        wi[j]=fi[k];
    }

    FFT(wr,wi,n,is);             // do FFT

    for(k=0,j=0; k<n*d; k+=d,j++)  // write back
    {
        fr[k]=wr[j];
        fi[k]=wi[j];
    }
}
/* =============== end WIDE_FFT =========== */


void 
wide_fft0(double *fr, double *fi, ulong n, ulong d, double *wr, double *wi, int is)
//
// compute fft of the n elements 
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong k,j;

    for(k=0,j=0; k<(n*d)/2; k+=d,j++)  // fill workspace
    {
        wr[j]=fr[k];
        wi[j]=fi[k];
    }

    for( ; k<n*d; j++)  // fill in zeros
    {
        wr[j]=0.0;
        wi[j]=0.0;
    }


    FFT0(wr,wi,n,is);             // do FFT


    for(k=0,j=0; k<n*d; k+=d,j++)  // write back
    {
        fr[k]=wr[j];
        fi[k]=wi[j];
    }
}
/* =============== end WIDE_FFT0 =========== */

