
#include "fxtaux.h"
#include "fxt.h"


// as 'Decimation In Frequency' is
// 'Decimation In _S_equency' here
// the names could also be dis2_xyz()


void 
dif2_walsh_wal(double *f, ulong ldn)
//
// transform wrt. to walsh-kaczmarz basis (wal-functions)
// the wal functions are sequency- ordered
//
{
    const ulong n=(1<<ldn);

    gray_scramble(f,n);

    scramble(f,n);

    dif2_walsh_wak(f,ldn);
}
// ================= end DIF2_WALSH_WAL ==================


void 
dif2_walsh_pal(double *f, ulong ldn)
//
// transform wrt. to walsh-paley basis (pal-functions)
//
{
    const ulong n=(1<<ldn);

    scramble(f,n);

    dif2_walsh_wak(f,ldn);
}
// ================= end DIF2_WALSH_PAL ==================


void 
dif2_walsh_wak(double *f, ulong ldn)
//
// transform wrt. to walsh-kronecker basis (wak-functions)
//
{
    const ulong n=(1<<ldn);

    for(ulong ldm=ldn; ldm>=1; --ldm)
    {
        const ulong m=(1<<ldm);
	const ulong mh=(m>>1);

        for(ulong j=0; j<mh; ++j)
        {
            for (ulong r=0; r<n; r+=m)
            {
                const ulong t1=r+j;
                const ulong t2=t1+mh;

                double u=f[t1];
		double v=f[t2];

                f[t1]=u+v;
                f[t2]=u-v;
            }
        }
    }
}
// ================= end DIF2_WALSH_WAK ==================
