
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdatafu.h"
#include "mybuiltin.h"



int
gt_mul_int(const hfguts &a, long i, hfguts &c)
//
// returns how many right shifts happened
//
{
    assert( c.writeable() );

    if( i==0 )  c.set_zero();

    int dx;
    unsigned long u;

    c.copy(a);

    c.sign(a.sign()*SIGN(i));
    c.exp(a.exp());

    u = ABS(i);

    dx = dt_mul_sh(*c.data(),c.prec(),u);

    c.exp(c.exp()+dx);

    return dx;
}
//================== end GT_MUL_INT ===================


/*
#define ILN 64
static hfguts x(ILN,0);


int
gt_mul_int(const hfguts &a, long i, hfguts &c)
{
    x.prec(ILN);
    long p=gt_from_int(i,x);
    x.prec(p);

    return gt_mul(a,x,c);
}
//================== end GT_MUL_INT ===================
*/
