
#include <assert.h>

#include "hfguts.h"
#include "hfdatafu.h"


#define PR(x)   // for debug


int
gt_sqr(const hfguts &a, hfguts &c, ulong pa, ulong pc)
//
// pa, pc default to 0
//
// returns how many right shifts happened
//
{
    assert( c.writeable() );

#if FORBID_UNNORMALIZED
    assert( a.normalized() );
#endif // FORBID_UNNORMALIZED

    PR( i_print("\n gt_sqr(): (LIMB)a[]=",a.dig(),8); );

    if ( a.is_zero() )
    {
        c.set_zero();
        return 0;
    }

    c.exp(a.exp() + a.exp() - 1 );

    c.sign(+1);

    if ( 0==pa )  pa = a.prec();
    if ( 0==pc )  pc = c.prec();


    int i;
    if ( pa<=16 )
    {
        i = dt_sqr_slow(*a.data(), pa, *c.data(), pc);
    }
    else
    {
        i = dt_sqr_fxt(*a.data(), pa, *c.data(), pc);
    }

    c.exp(c.exp()+i);

    PR( i_print("\n gt_sqr(): (LIMB)c[]=",c.dig(),8); );


#if FORBID_UNNORMALIZED
    assert( c.normalized() );
#endif // FORBID_UNNORMALIZED

    return i;
}
//============================= end GT_SQR =======================
