
#include "hfloatfu.h"
#include "hfverbosity.h"
#include "hfgutsfu.h"


#define  A  (*(a.guts()))
#define  B  (*(b.guts()))
#define  C  (*(c.guts()))



hfloat
inv(const hfloat &h)
{
    hfloat h3;
    inv(h,h3);
    return h3;
}
// -----------------



void
inv(const hfloat &d, hfloat &c, ulong startprec) // =0
//
// startprec here for the inv
// (which has to be in c)
//
{
    assert( !d.is_zero() ); // division by zero

    //    return inv_iteration(d,c,startprec);
    iroot_iteration(d,1,c,startprec);
}
//===================== end INV ================================



void
div(const hfloat &a, const hfloat &b, hfloat &c, ulong startprec) // =0
//
// startprec here for the inv !
// (which has to be in c)
//
{
    if( same_mantissa(a,c) )
    {
        hfloat ct(c.prec());
        //	inv_iteration(b,ct,startprec);
        //	iroot_iteration(b,1,ct,startprec);
        inv(b,ct,startprec);
	mul(a,ct,c);
    }
    else
    {
        inv(b,c,startprec);
	mul(a,c,c);
    }
}
//===================== end DIV ================================


void
div(const hfloat &a, long i, hfloat &c, int *rem)  // =0
{
    gt_div_int(A,i,C,rem);
}
//===================== end DIV ================================


void
div_by_radix_pow(const hfloat &a, int ex, hfloat &b)
{
    b = a;
    B.exp( B.exp()-ex );
}
// ================= end DIV_BY_RADIX_POW ==================


//
// fmod() and divmod() are hacks ...
//

void
fmod(const hfloat &a, const hfloat &b, hfloat &m)
//
// m := b*frac(a/b)
//
{
    //    assert( !same_mantissa(a,m) );
    assert( !same_mantissa(b,m) );

    div(a,b,m);
    frac(m,m);
    mul(m,b,m);  // b*frac( a/b )
}
//========================= end FMOD =======================


void
fmod(const hfloat &a, const hfloat &b, hfloat &m, hfloat &d)
//
// m := b*frac(a/b)
// d := floor(a/b)
//
// this relation holds: a ==  b*floor(a/b) + b*frac(a/b)
//
// note that the C function fmod uses 'round toward zero'
// instead of 'floor' used here
//
{
    assert( !same_mantissa(m,d) );

    //    assert( !same_mantissa(a,m) );
    //    assert( !same_mantissa(a,d) );

    assert( !same_mantissa(b,m) );
    assert( !same_mantissa(b,d) );

    div(a,b,m);

    // use round0(m,d) to get an fmod like the c-function
    floor(m,d);   // floor( a/b )

    // use frac0(m,m) when using round0() above,
    // then this relation might be useful:
    //    a ==  b*round0(a/b) + b*frac0(a/b)
    frac(m,m);

    mul(m,b,m);   // b*frac( a/b )
}
//========================= end FMOD ====================

