
#include <math.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "hfverbosity.h"
#include "mybuiltin.h"


hfloat
pow(const hfloat &h, long p)
{
    hfloat h3;
    pow(h,p,h3);
    return h3;
}
// -----------------



void
pow(const hfloat &a, long e, hfloat &c)
{
    ulong x = ABS(e);

    char *v = hfverbosity::powbegin;
    if ( x!=1 )
    {
        say(v);
        if ( v )  cout << e << ':';
    }

    if ( x>=3 )
    {
        pow_geq_3(a,x,c);
    }
    else
    {
        switch ( x )
        {
        case 2: sqr(a,c); break;
        case 1: copy(a,c); break;
        case 0: u2hfloat(1,c); break;
        }
    }

    if ( e<0 )  inv(c,c);

    if ( x!=1 )  say( hfverbosity::powend );
}
//======================= end POW =============================


void
pow_geq_3(const hfloat &a, ulong ex, hfloat &c)
//
// c=a^ex
// exponent >= +3 
//
{
    assert( ex>=3 );

    int firstq;

    if ( ex==((ulong)1<<ld(ex)) )  // special case ex==2^n
    {
        sqr(a,c);

        while ( ex>2 )
        {
            sqr(c,c);
            ex /= 2;
        }
    }
    else
    {
	hfloat at(c.prec());
        at = a;

	firstq = 1;
	while ( 1 )
	{
	    if (ex&1)  // odd
	    {
		if (firstq)     // avoid multiplication by 1
		{
		    copy(at,c);
		    firstq = 0;
		}
		else
		{
		    mul(c,at,c);
		}

		if ( ex==1 )  break;
	    }

	    sqr(at,at);
	    ex /= 2;
	}
    }
}
// ========================== end POWER_GEQ_3 ==============================
