#if !defined __MYBUILTN_H
#define      __MYBUILTN_H


#include "types.h"



#define LOG10(x)     (log(x)/log(10.0))
#define LOG2(x)      (log(x)/log(2.0))
//#define ROUND(x)     (floor(x+0.5))
#define SQR(x)       (x*x)
#define SIGN(x)      ((x)>0?+1:((x)<0?-1:0))
#define ABS(x)       ((x)>=0?(x):(-x))
#define MAX(x,y)     ((x)>(y)?(x):(y))
#define MAX3(x,y,z)  (MAX(x,MAX(y,z)))
#define MIN(x,y)     ((x)<(y)?(x):(y))
#define MIN3(x,y,z)  (MIN(x,MIN(y,z)))
#define CHOP(x)      (fabs(x)<1e-12 ? 0:x)

//#define RND01        ( -(double)rand() / ( 1.*(1<<31)))   
// random number in [0,1.0[




#if defined __GNUC__

#include <builtin.h>

#define SWAP(x,y)  { typeof(x) tmp=x; x=y; y=tmp; }

#else

void start_timer();
double return_elapsed_time();

template <class T> inline void
SWAP(T &x, T &Y)
{
    T tmp = x; 
    x = y;
    y = tmp; 
}

long gcd(long a, long b);  // see gcd.cc

#endif // defined __GNUC__


inline ulong ld(ulong x)  // replaces lg()
// returns k so that 2^k <= x < 2^(k+1)
{
    ulong k=0; 
    while(x>>=1)  ++k; 
    return k;
}

inline int ispowof(long x, int p)
// returns 0 or k so that p^k==x
{
    int k=0;
    while( x>1 && x==(x/p)*p )  { x/=p; k++; }
    return (x==1?k:0);
}



#endif // !defined __MYBUILTN_H
