#include <math.h>
#include <std.h>
#include <iostream.h>
#include <assert.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"

int
doit(const hfloat &a, hfloat &b, hfloat &c, hfloat &d, 
     ulong startprec)
{
    for(int k=-8; k<=8; ++k)
    {
        cout<<"\n ---- root/pow k="<<k<<": "<<endl;

        root(a,k,b);       // b = a^(1/k)
        if ( startprec )  root(a,k,b);

        print("\n b=",b,8);

        pow(b,k,c);        // c = b^k
        print("\n c=",c,8);

        if ( k!=0 )
        {
            c -= a;
            print("\n TEST 0=?=",c,8);

            if( c.exp() > (-c.prec()+7) )
            {
                cout<<"\n ERROR at k="<< k <<" ! "<<endl;
                cerr<<"\n ERROR at k="<< k <<" ! "<<endl;
            }
        }

    }
}
//-----------------------------------------------------
 

int
test2(long nn)
{
    cout<<"\n TEST2 "<<flush;

    hfloat a(nn), b(nn), c(nn), d(nn);

    d2hfloat(1.0/M_PI,a);

    ulong sp = nn/3;


    doit(a,b,c,d, 0);


    cout<<"\n ================  startprec: "<<endl;
    doit(a,b,c,d, sp);


    a.prec(5);
    cout<<"\n ================  short input: "<<endl;
    doit(a,b,c,d, 0);


    cout<<"\n ================  startprec: "<<endl;
    doit(a,b,c,d, sp);


    return 0;
}
//========================= end TEST2 =====================

