#include <math.h>
#include <std.h>
#include <iostream.h>
#include <assert.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"
//#include "../src/dt/auxid.h"

#include "../src/fxt/fxt.h"


// time the iterations:

const int doall = 0;


const int TIME_INV = 1;
const int TIME_ISQRT = 1;
const int TIME_CUBE_ROOT = 1;
const int TIME_INROOT = 1;
const int TIME_ROOTX = 1;
const int TIME_LOG = 0;
const int TIME_EXP = 0;



#define  XYZ  t0=0; start_timer(); for(k=0; k<mct; ++k)


int k,mct;
double tm;
double dt,tt,t0;

void
PRINTIT(char *bla)
{
    dt=return_elapsed_time()-t0;
    tt=dt/(double)mct;
    if(tm==0)  tm=tt;  // time for one multiplication
    double  opsec = (tt==0?0:1.0/tt);
    cout.form(" %s:  %5.3g mult,  %8.5g Hz , %6.2e sec/op  ", bla,tt/tm,opsec,tt);
    cout.form(" [dt=%5.3g  mct=%3d]",dt,mct);
    cout<<endl;
}


int
time_iterations(long n1, long nn) // --------------------------------------
{
    hfloat a(nn),b(nn),c(nn),d(nn);

    rand(a); a.sign(+1); a.exp(+17);
    rand(b); b.sign(+1); b.exp(-88);
    //    print("\n a=",a,8);
    //    print("\n b=",b,8);

    long nnmax = nn;
    nn = n1;  // comment this line out to get timing for only one nn
    for( ; nn<=nnmax; nn*=2)
    {
	a.prec(nn);
	b.prec(nn);
	c.prec(nn);
	d.prec(nn);

        cout.form(" ------------- prec =%d LIMBs (=%d dec.dig., =%d bits): -------------- \n",
		  nn,a.dec_prec(),a.bit_prec());

	tm=0;
    }
    mct=MAX((1<<16)/nn,1);

    XYZ mul(a,b,c);
    PRINTIT("mul.............");

    XYZ sqr(a,c);
    PRINTIT("sqr.............");


    mct=MAX((1<<14)/nn,1);

    if ( doall || TIME_INV )
    {
        XYZ inv(a,c,0); PRINTIT("inv.............");
        b=3; b.prec(2);
        XYZ inv(b,c,0); PRINTIT("inv.short.......");
        b.prec(nn);
    }

    if ( doall || TIME_ISQRT )
    {
        XYZ isqrt(a,c,0); PRINTIT("isqrt...........");
        XYZ isqrt(3,c,0); PRINTIT("isqrt.short.....");
    }


    mct=MAX(mct/2,1);

    if ( doall || TIME_CUBE_ROOT )
    {
        XYZ cbrt(a,c); PRINTIT("cbrt............");
        XYZ cbrt(3,c); PRINTIT("cbrt.short......");
    }


    if ( doall || TIME_INROOT )
    {
        XYZ iroot(a,4,c,0); PRINTIT("iroot_4.........");
        XYZ iroot(3,4,c,0); PRINTIT("iroot_4.short...");
    }


    if ( doall || TIME_ROOTX )
    {
        XYZ root_x(a,4,c); PRINTIT("root_x_4........");
        XYZ root_x(3,4,c); PRINTIT("root_x_4.short..");
    }


    if ( doall || TIME_LOG )
    {
        mct=1; XYZ log(a,c); PRINTIT("log.............");
    }

    if ( doall || TIME_EXP )
    {
        mct=1; XYZ exp(a,c); PRINTIT("exp.............");
    }

    return 0;
}
//================================= end TIME_IT =======================

