#include <string.h>
#include <time.h>
#include "natural.h"

#ifndef _Old_STD_
# define NOTHROW_NEW  new(nothrow)
#else
# define NOTHROW_NEW  new
#endif


Natural cfrac(const Natural& a, const Digit m, const Digit c)
// Algorithm:  q := cfrac(a, b, c)
// Input:      a in Natural, b,c in Digit where b >= 50, c >= 1.
// Output:     b in Natural such that q | a ||
{
  struct prim_t {
    Natural* x;
    char*    c;
  };
  Natural s,s2,s3,r,v,y;
  Natural t = 1;
  const Digit pm = 3;
  Digit* p = NOTHROW_NEW Digit[m];
  if (!p) a.errmsg(2, "(cfrac)");
  p[0] = p[1] = 0;

  prim_t* d = NOTHROW_NEW prim_t[m+1];
  if (!d) a.errmsg(2, "(cfrac)");
  Digit i;
  for (i = 0; i <= m; ++i) {
    d[i].x = NOTHROW_NEW Natural[3];
    if (!d[i].x) a.errmsg(2, "(cfrac)");
    d[i].c = NOTHROW_NEW char[m];
    if (!d[i].c) a.errmsg(2, "(cfrac)");
    memset(d[i].c, 0, m);
  }
  for (Natural b = c*a; t == 1; b += a) {
    sqrt(b, r, v);
    Natural w = r;
    Natural z = 1;
    Natural u = 1;
    r <<= 1;
    Natural x = r;
    Digit prim = a.firstPrime();
    Digit n = 2;
    while (a.nextPrime(prim) && n < m) {
      Digit q = b % prim;
      Digit q2 = 1;
      for (i = prim/2; i > 1; i /= 2) {
        if (i&1) { q2 *= q; q2 %= prim; }
        q *= q; q %= prim;
      }
      q2 *= q; q2 %= prim;
      if (q2 <= 1) p[n++] = prim;
    }
    Natural trial = 1;
    for (i = 2; i < pm; ++i);
    while (i < n) trial *= p[i++];

    Digit nd = 0;
    Digit iteration = 0;
    while (true) {
      ++iteration;
      t = v;
      if (t == 1) break;
      while ((t&3) == 0) t >>= 2;
      d[nd].c[1] = char(t.even());
      if (d[nd].c[1]) t >>= 1;
      for (i = 2; i < pm && t > 1; ++i) {
        const Digit k = p[i]*p[i];
        const Digit l = k*p[i];
        Digit m;
        while (true) {
          div(t, k*k, s, m);
          if (m) break;
          swap(t, s);
        }
        if (m%l == 0) {
          d[nd].c[i] = 1;
          t /= l;
        } else if (m%k == 0) {
          d[nd].c[i] = 0;
          t /= k;
        } else if (m%p[i] == 0) {
          d[nd].c[i] = 1;
          t /= p[i];
        } else d[nd].c[i] = 0;
      }
      if (t > 1) {
        div(trial, t, s, s2);
        if (s2 != 0) {
          s2 *= s2; s2 %= t;
          if (s2 != 0) { s2 *= s2; s2 %= t; }
        }
      }
      if (t == 1 || s2 == 0) {
        if (t > 1) {
          s = t;
          Digit j,k;
          do {
            k = p[i]*p[i];
            div(s, k, t, j);
            if (j == 0) {
              swap(s, t);
              --i;
            } else if (j%p[i] == 0) {
              d[nd].c[i] = 1;
              s /= p[i];
            }
            ++i;
          } while (s > k);
          if (s != 1) {
            while (s > p[i]) ++i;
            d[nd].c[i] = 1;
          }
        }
        d[nd].c[0] = char(iteration&1);
        d[nd].x[0] = w; d[nd].x[1] = v; d[nd].x[2] = 1;
        Digit j;
        for (j = 0; j < n && d[nd].c[j] == 0; ++j);
        Digit k = 0;
        for (i = 0; i < nd && j < n; ++i) {
          while (d[i].c[k] == 0) ++k;
          if (k == j) {
          d[nd].c[k] = 0;
          for (Digit l = ++k; l < n; ++l) d[nd].c[l] ^= d[i].c[l];
            d[nd].x[0] *= d[i].x[0];
            d[nd].x[0] %= a;
            t = gcd(d[nd].x[1], d[i].x[1]);
            d[nd].x[1] *= d[i].x[1];
            d[nd].x[1] /= t*t;
            d[nd].x[2] *= t;
            d[nd].x[2] *= d[i].x[2];
            d[nd].x[2] %= a;
            while (j < n && d[nd].c[j] == 0) ++j;
          } else if (k > j) {
            prim_t tP = d[nd];
            Digit l;
            for (l = nd; l > i; --l) d[l] = d[l-1];
            d[l] = tP;
            ++i;
            while (true) {
              if (d[l].c[k]) {
                d[l].c[k] = 0;
                for (Digit l2 = k+1; l2 < n; ++l2) d[l].c[l2] ^= d[i].c[l2];
                d[l].x[0] *= d[i].x[0];
                d[l].x[0] %= a;
                t = gcd(d[l].x[1], d[i].x[1]);
                d[l].x[1] *= d[i].x[1];
                d[l].x[1] /= t*t;
                d[l].x[2] *= t;
                d[l].x[2] *= d[i].x[2];
                d[l].x[2] %= a;
              }
              if (++i > nd) break;
              while (d[i].c[++k] == 0);
            }
            for (i = 0; i < l; ++i)
              if (d[i].c[j]) {
              d[i].c[j] = 0;
              for (Digit l2 = j+1; l2 < n; ++l2) d[i].c[l2] ^= d[l].c[l2];
              d[i].x[0] *= d[l].x[0];
              d[i].x[0] %= a;
              t = gcd(d[l].x[1], d[i].x[1]);
              d[i].x[1] *= d[l].x[1];
              d[i].x[1] /= t*t;
              d[i].x[2] *= t;
              d[i].x[2] *= d[l].x[2];
              d[i].x[2] %= a;
            }
            i = ++nd;
          } else ++k;
        }
        if (j == n) {   // Solution?
          Natural y = sqrt(d[nd].x[1]) * d[nd].x[2];
          y %= a;
          t = a-y;
          if (d[nd].x[0] != y && d[nd].x[0] != t) {
            y += d[nd].x[0];
            t = gcd(y, a);
            v = 2;
            break;
          } else memset(d[nd].c, 0, n);
        } else if (i == nd) {
          for (i = 0; i < nd; ++i)
            if (d[i].c[j]) {
              d[i].c[j] = 0;
              for (Digit l2 = j+1; l2 < n; ++l2) d[i].c[l2] ^= d[nd].c[l2];
              d[i].x[0] *= d[nd].x[0];
              d[i].x[0] %= a;
              t = gcd(d[nd].x[1], d[i].x[1]);
              d[i].x[1] *= d[nd].x[1];
              d[i].x[1] /= t*t;
              d[i].x[2] *= t;
              d[i].x[2] *= d[nd].x[2];
              d[i].x[2] %= a;
          }
          ++nd;
        }
      }
      div(x, v, s, t);                  // Kettenbruchentwicklung
      y = r-t; z += w*s; z %= a;
      if (x >= y) {
        t = x-y; t *= s; u += t;
      } else {
        t = y-x; t *= s; u -= t;
      }
      swap(v, u); swap(x, y); swap(w, z);
    }
    for (i = 0; i < nd; ++i) memset(d[i].c, 0, n);

    cout << "Iterationen=" << iteration << endl;
    cout << "Matrix size=" << nd << endl;
  }
  for (i = 0; i <= m; ++i) {
    delete[] d[i].x;
    delete[] d[i].c;
  }
  delete[] d;
  delete[] p;
  return t;
}

int main()
{
  Natural a = 1;
  a <<= 128; ++a;

  clock_t start = clock();
  Natural c = cfrac(a, 400, 257);
  clock_t stop = clock();
  cout << "time [s] = " << double(stop-start)/CLOCKS_PER_SEC << endl;

  cout << c << '*' << a/c << endl;

  return 1;
}
