%define DATUM    March 18, 1998
%define AUTOR    Sebastian Wedeniwski
%define VERSION  1.2.1
%define EDITION  1.2.1

\documentclass{book}

\usepackage{amssymb}
\usepackage[german]{babel}
\usepackage{piologie}
\usepackage{makeidx}
\usepackage{latexsym}


% HP LaserJet 5P
% \setlength{\topmargin}{-0.3cm}
% \setlength{\evensidemargin}{0cm}
% \setlength{\oddsidemargin}{0.4cm}

% HP LaserJet 4
% \setlength{\topmargin}{-2.3cm}
% \setlength{\evensidemargin}{0.9cm}
% \setlength{\oddsidemargin}{1.1cm}

% \setlength{\parindent}{0cm}
% \setlength{\textheight}{23.5cm}
% \setlength{\textwidth}{15cm}

% DIN A4 Format:  (LiDIA-Dokumentationsvorlage)
\topmargin0.0cm
\textwidth15.8cm \textheight22cm
\oddsidemargin3mm \evensidemargin-5.0mm
\parindent0mm \parskip1ex plus0.5ex minus0.3ex


\makeindex

\hyphenation{Di-visions-operatio-nen Ket-ten-bruch-ent-wicklung Test-sy-ste-me Arith-me-tik Ad-di-tions-funk-tion
			 Li-near-kom-bi-na-tio-nen}


% The following are also needed for \maketitle
\title{{\huge \Piologie}\\ Eine exakte arithmetische Bibliothek in \cpp\\ {\small Edition 1.2.1}}
\author{Sebastian Wedeniwski}
% The following are needed for \makefrontpage
\plainauthor{Sebastian Wedeniwski}                        % authors without decoration/address
\reportnumber{WSI 96-35}                                  % the number of the technicalreport
\email{\texttt{wedeniws\symbol{"40}informatik.uni-tuebingen.de}}      % email for correspondence
\appyear{1996}                                            % the year of appearance/copyright
\date{18. M\"arz 1998}




\begin{document}

% Optional
% \makefrontpage prepends a page for the WSI technical report series
% Needs \title, \plainauthor, \date, \email, and \appyear
\makefrontpage

% Optional
% Needs \title, \author, and \date (see documentstyle ``article'' in LaTeX)
% \maketitle


%\setlength{\evensidemargin}{0.7cm}

% HP LaserJet 5P
% \setlength{\oddsidemargin}{0cm}
% \setlength{\evensidemargin}{0.1cm}

% HP LaserJet 4
\setlength{\oddsidemargin}{0.6cm}
\setlength{\evensidemargin}{0.4cm}


\thispagestyle{empty}
\mbox{}\vfill
\textbf{Urheberrechte.}\\
Diese Bibliothek ist frei; das hei"st, da"s jeder sie auf einer freien Grundlage benutzen und weiterverteilen kann.
F"ur alle "Anderungen und Ausz"uge liegen jedoch die Rechte beim Autor.
In diesem Zusammenhang "ubernehme ich nat"urlich keine Garantie f"ur die \Piologie-Bibliothek.\\

Die genauen Rechtsmodalit"aten entsprechen denen in der Library General Public License festgelegten.
\clearpage
\thispagestyle{empty}

\small\begin{quotation}
\noindent \textbf{Zusammenfassung.}
\Piologie\ ist eine Bibliothek f"ur eine beliebig genaue Arithmetik, die mit nat"urlichen und ganzen Zahlen operiert.\\
\noindent Die Effizienz der Algorithmen in Theorie und Praxis und die Implementierung in ANSI-\cpp\ nach neuestem Stand
sind die grundlegenden Forderungen dieser Bibliothek. Dabei ist die Arithmetik auf alle Systeme portabel und vom Compiler
unabh"angig, da sie nur einen einzigen Grunddatentyp verwendet und dadurch ohne Laufzeiteinbu"sen Assembler vermeiden
kann.\\  
"Ubersichtlichkeit und leichte Handhabung der Bibliothek gew"ahrleisten schlie"slich die einfachen Funktionsaufrufe,
die f"ur sich selbsterkl"arend sind, und die einschr"ankungsfreie Argument"ubergabe.\\

\noindent\footnotesize\begin{tabbing}
Die vorliegende Arbeit ist auf den Prozessoren\\
\\
\qquad\=  80486, Pentium, PentiumPro, Pentium II,\\
\>DEC alpha,\\
\>HP PA,\\
\>IBM RS6000, PowerPC,\\
\>MIPS,\\
\>SuperSPARC, UltraSPARC\\
\\
mit den Compilern\\
\\
\>Apogee \cpp\ 3.0,\\
\>Borland \cpp\ 5.02,\\
\>Digital \cpp\ 5.0,\\
\>Edison Design Group \cpp\ front end 2.33,\\
\>GNU \cpp\ 2.6.1 - 2.8.1,\\
\>HP \cpp\ A.10.22, HP a\cpp\ A.01.00,\\
\>IBM C Set++ for AIX 3.1.1, IBM Visual Age \cpp\ 3.0,\\
\>KAI \cpp\ 3.2,\\
\>Microsoft Visual \cpp\ 5.0,\\
\>SGI MIPSpro \cpp\ 7.1,\\
\>SUN WorkShop \cpp\ 4.2,\\
\>Watcom \cpp\ 11.0\\
\\
unter den Systemen\\
\\
\>SunOS, Solaris, Irix, HP-UX, AIX, Digital Unix, Linux, OS/2, Windows NT/95, DOS32\\
\\
getestet worden.
\end{tabbing}\small

\noindent Auf einem (2x)UltraSPARC 200 MHz erreichen wir mit dem GNU-\cpp\ Compiler 2.8.0 die folgenden Zeiten:\\

\noindent\footnotesize\mbox{}\hfill\begin{tabular}{l|r|r|r|r|r}
Algorithmus & \Piologie & GMP & \Piologie\ 1.2 & GMP 2.0.2 & freelip 1.1\\
& 1.2 & 2.0.2 &  (No Asm) & (No Asm) &\\
\hline
Fibonacci(800000) & 2.8 s & 6.51 s & 4.49 s & 6.88 s & 4.17 s\\
Fibonacci(900000) & 2.9 s & 7.67 s & 4.67 s & 8.12 s & 5.08 s\\
Quadratwurzel & 9.2 s & 20.3 s & 15.94 s & 20 s & 564.49 s\\
Multiplikation & 2.67 s & 8.39 s & 4.61 s & 8.9 s & 8.23 s\\
Quadratur & 3.88 s & 20.44 s & 6.67 s & 21.59 s & 13.93 s\\
Division & 3.11 s & 13.74 s & 5.52 s & 13.4 s & 15.86 s
\end{tabular}\hfill\mbox{}\bigskip\smallskip\small\\

\noindent Auf einem (2x)Pentium II 233 MHz erzielen wir mit dem GNU-\cpp\ Compiler 2.7.2 folgende Werte:\\

\noindent\footnotesize\mbox{}\hfill\begin{tabular}{l|r|r|r|r|r|r}
Algorithmus & \Piologie & GMP & \Piologie & GMP & freelip & \Piologie\\
&&&  (No Asm) & (No Asm) && (MSV, No Asm)\\
\hline
Fibonacci(800000) & 1.61 s & 1.56 s & 2.77 s & 4.58 s & 2.34 s & 1.98 s\\
Fibonacci(900000) & 1.73 s & 1.81 s & 3.09 s & 5.39 s & 2.77 s & 2.28 s\\
Quadratwurzel & 5.59 s & 4.16 s & 12.4 s & 11.75 s & 195.97 s & 9.20 s\\
Multiplikation & 1.48 s & 2.02 s & 4.69 s & 5.92 s & 3.91 s & 3.91 s\\
Quadratur & 2.22 s & 4.86 s & 6.88 s & 14.52 s & 7.72 s & 5.72 s\\
Division & 2.27 s & 2.81 s & 3.41 s & 7.77 s & 5.44 s & 2.31 s
\end{tabular}\hfill\mbox{}\small\\

\noindent\textbf{Resultat.} Moderne Architekturen machen Assembler hinf"allig.
\end{quotation}



\clearpage\normalsize\mbox{}
\thispagestyle{empty}\mbox{}
\clearpage
%\cleardoublepage
\pagenumbering{roman}
\tableofcontents
\clearpage
\thispagestyle{empty}\cleardoublepage
\pagenumbering{arabic}



\chapter{Grundlagen}
%###################

@i basic.w


\chapter{Die Arithmetik nat"urlicher Zahlen}
%###########################################

@i natural.w


\chapter{Die ganzen Zahlen}
%##########################

@i integer.w


%\chapter{Der Quotientenk"orper}
\chapter{Die rationale Arithmetik}
%#################################

@i rational.w


\chapter{Kleine Zahlentheorie}
%#############################

@i primes.w


\chapter{Konstanten-Berechnung}
%##############################

@i pi.w


\begin{appendix}

\chapter{Notation und Symbolik}
%##############################

\input symbol.tex

\chapter{Testprogramm und Laufzeiten}
%####################################

@i test.w

\chapter{$\zeta(3)$-Rekord}
%##########################

@i zeta.w

\chapter{Zusammenfassung}
%########################

@i digit.w

\chapter{Formeln zur $\pi$-Berechnung}
%#####################################

\input pi_equ.tex

\end{appendix}


% Literaturverzeichnis
%#####################

\clearpage
\input lit.tex

% Index
%######

\clearpage
\addcontentsline{toc}{chapter}{Index}
\printindex


\clearpage
{\Large \textbf{Dateien}}
%------------------------

@f
\vspace*{4ex}

{\Large \textbf{Makros}}
%-----------------------

@m

\vspace*{4ex}

{\Large \textbf{Funktionsnamen}}
%-------------------------------

@u

\end{document}
