@d class \Rational\
@{// Unfortunatelly not:
//typedef Rational<Integer, Natural> Rational;
@| Rational @}

\section{Konstruktoren und Destruktor}
%=====================================

@D default constructor \Rational\
@{inline Rational::Rational(const Digit a)
 : num(a), den(1)
// Algorithm:  c := Rational(a)
// Input:      a in Digit.
// Output:     c in Rational such that c = a/1 ||
{
}
@| Rational::Rational Rational @}

@D overloaded constructor \Rational\ for \Integer\
@{inline Rational::Rational(const Integer& a)
 : num(a), den(1)
// Algorithm:  c := Rational(a)
// Input:      a in I.
// Output:     c in Rational such that c = a/1 ||
{
}
@| Rational::Rational Rational @}

@D overloaded constructor \Rational\ for \Integer\ and \Natural\
@{Rational::Rational(const Integer& a, const Natural& b)
 : num(a), den(b)
// Algorithm:  c := Rational(a, b)
// Input:      a in Integer, b in Natural where not b = 0.
// Output:     c in Rational such that c = a/b ||
{
  if (b == 0) den.errmsg(4, "(constructor)");
  const Natural t = gcd(abs(a), b);
  num /= t; den /= t;
}
@| Rational::Rational Rational @}

@d copy constructor \Rational\
@{inline Rational::Rational(const Rational& a)
 : num(a.num), den(a.den)
// Algorithm:  c := Rational(a)
// Input:      a in Rational.
// Output:     c in Rational such that c = a ||
{
}
@| Rational::Rational Rational @}

@d destructor \Rational\
@{inline Rational::~Rational()
{
}
@| Rational::~Rational ~Rational @}



\section{Selektoren}
%===================

@D quotient field numerator (memberfunction)
@{inline const Integer& Rational::numerator() const
// Algorithm:  c := a.numerator()
// Input:      a in Rational.
// Output:     c in Integer such that c = a_1 where a_1/a_2 = a ||
{
  return num;
}
@| Rational::numerator numerator @}

@d quotient field numerator
@{inline const Integer& numerator(const Rational& a)
// Algorithm:  c := numerator(a)
// Input:      a in Rational.
// Output:     c in Integer such that c = a_1 where a_1/a_2 = a ||
{
  return a.numerator();
}
@| numerator @}

@d quotient field denominator (memberfunction)
@{inline const Natural& Rational::denominator() const
// Algorithm:  c := a.denominator()
// Input:      a in Rational.
// Output:     c in Natural such that c = a_2 where a_1/a_2 = a ||
{
  return den;
}
@| Rational::denominator denominator @}

@d quotient field denominator
@{inline const Natural& denominator(const Rational& a)
// Algorithm:  c := denominator(a)
// Input:      a in Rational.
// Output:     c in Natural such that c = a_2 where a_1/a_2 = a ||
{
  return a.denominator();
}
@| denominator @}



\section{Absolutbetrag}
%======================

@D absolute value of a \Rational\
@{inline Rational abs(const Rational& a)
// Algorithm:  c := abs(a)
// Input:      a in Rational.
// Output:     c in Rational such that c = |a| ||
{
  return Rational(abs(a.numerator()), a.denominator());
}
@| abs @}



\section{Vorzeichen}
%===================

@D sign of a \Rational\
@{inline int sign(const Rational& a)
// Algorithm:  c := sign(a)
// Input:      a in Rational.
// Output:     c in int such that if a = 0 then c = 0
//             else if a > 0 then c = 1 else c = -1 ||
{
  return sign(a.numerator());
}
@| sign @}



\section{Vertauschen zweier \Rational s}
%=======================================

@D function swap for \Rational s
@{inline void swap(Rational& a, Rational& b)
// Algorithm:  swap(a, b)
// Input:      a,b in Rational.
// Output:     a,b in Rational such that t := a, a := b, b := t
//             where t in Rational ||
{
  swap(a.num, b.num);
  swap(a.den, b.den);
}
@| swap @}


\section{Kopierfunktionen}
%=========================

@D assign \verb#operator=# for \Rational s
@{inline Rational& Rational::operator=(const Rational& a)
// Algorithm:  c := c = a
// Input:      a,c in Rational.
// Output:     c in Rational such that c = a ||
{
  num = a.num; den = a.den;
  return *this;
}
@| Rational::operator= operator= @}

@d assign \verb#operator=# for a \Rational\ with a \Digit\
@{inline Digit Rational::operator=(const Digit a)
// Algorithm:  c := b = a
// Input:      a in Digit, b in Rational.
// Output:     b in Rational, c in Digit such that b = a/1, c = a ||
{
  num = a; den = 1;
  return a;
}
@| Rational::operator= operator= @}

@d assign \verb#operator=# for a \Rational\ with a \Integer\
@{inline Rational& Rational::operator=(const Integer& a)
// Algorithm:  c := c = a
// Input:      a in Integer, c in Rational.
// Output:     c in Rational such that c = a/1 ||
{
  num = a; den = 1;
  return *this;
}
@| Rational::operator= operator= @}



\section{Streamausgabe}
%======================

@D puts a \Rational\ on output stream
@{inline ostream& operator<<(ostream& out, const Rational& a)
// Algorithm:  o := o << a
// Input:      o in ostream, a in Rational.
// Output:     o in ostream ||
//
// Note:       puts Rational a on output stream.
{
  return out << a.numerator() << '/' << a.denominator();
}
@| operator<< @}


\subsection{Interne Darstellung}
%-------------------------------

@d puts internal representation of a \Rational\ on output stream
@{inline ostream& operator<<(ostream& out, const Rational::rep& a)
// puts internal representation of Rational a on output stream.
{
  return out << print(a.num) << '/' << print(a.den);
}
@| operator<< @}

@d output variables for representation of a \Rational\
@{struct rep {
  const Integer& num;
  const Natural& den;
  rep(const Integer& a, const Natural& b)
    : num(a), den(b) {}
};
@}

@d function \verb#print# of a \Rational\
@{inline Rational::rep print(const Rational& a)
// Algorithm:  o := o << print(a)
// Input:      o in ostream, a in Rational.
// Output:     o in ostream ||
//
// Note:       puts internal representation of Rational a on an output stream.
{
  return Rational::rep(a.numerator(), a.denominator());
}
@| print @}



\section{Streameingabe}
%======================

@D gets a \Rational\ from input stream
@{istream& operator>>(istream& in, Rational& a)
// Algorithm:  i := i >> a
// Input:      i in istream.
// Output:     i in istream, a in Rational ||
//
// Note:       gets Rational a from input stream.
{
  in >> a.num;
  char ch = 0;
  if (in.get(ch) && ch != '/') { in.putback(ch); return in; }
  in >> a.den;
  if (a.den == 0) a.den = 1;
  Natural b = gcd(abs(a.num), a.den);
  a.num /= b; a.den /= b;
  return in;
}
@| operator>> @}


\subsection{Interne Darstellung}
%-------------------------------

@D gets internal representation of a \Rational\ from input stream
@{bool Rational::scan(istream& in)
// Algorithm:  b := a.scan(i)
// Input:      a in Rational, i in istream.
// Output:     a in Rational, i in istream, b in bool ||
//
// Note:       gets Rational a as an internal representation from input stream
//             if b is true.
{
  if (!num.scan(in)) return false;
  char c = 0;
  if (in.get(c) && c != '/') { in.putback(c); return false; }
  return den.scan(in);
}
@| Rational::scan scan @}


\section{Vergleichsoperatoren}
%=============================

@D comparison \verb#operator==# for \Rational s
@{inline bool operator==(const Rational& a, const Rational& b)
// Algorithm:  c := a == b
// Input:      a,b in Rational.
// Output:     c in bool such that if a = b then c = true else c = false ||
{
  return (a.numerator() == b.numerator() && a.denominator() == b.denominator());
}
@| operator== @}

@d comparison \verb#operator!=# for \Rational s
@{
inline bool operator!=(const Rational& a, const Rational& b)
// Algorithm:  c := a != b
// Input:      a,b in Rational.
// Output:     c in bool such that if a = b then c = false else c = true ||
{
  return (a.numerator() != b.numerator() || a.denominator() != b.denominator());
}
@| operator!= @}

@d comparison \verb#operator<# for \Rational s
@{inline bool operator<(const Rational& a, const Rational& b)
// Algorithm:  c := a < b
// Input:      a,b in Rational.
// Output:     c in bool such that if a < b then c = true else c = false ||
{
  return (a.numerator()*b.denominator() < a.denominator()*b.numerator());
}
@| operator< @}

@d comparison \verb#operator<=# for \Rational s
@{inline bool operator<=(const Rational& a, const Rational& b)
// Algorithm:  c := a <= b
// Input:      a,b in Rational.
// Output:     c in bool such that if a <= b then c = true else c = false ||
{
  return (a.numerator()*b.denominator() <= a.denominator()*b.numerator());
}
@| operator<= @}

@d comparison \verb#operator># for \Rational s
@{inline bool operator>(const Rational& a, const Rational& b)
// Algorithm:  c := a > b
// Input:      a,b in Rational.
// Output:     c in bool such that if a > b then c = true else c = false ||
{
  return (a.numerator()*b.denominator() > a.denominator()*b.numerator());
}
@| operator> @}

@d comparison \verb#operator>=# for \Rational s
@{inline bool operator>=(const Rational& a, const Rational& b)
// Algorithm:  c := a >= b
// Input:      a,b in Rational.
// Output:     c in bool such that if a >= b then c = true else c = false ||
{
  return (a.numerator()*b.denominator() >= a.denominator()*b.numerator());
}
@| operator>= @}

\subsection{\Digit-Vergleiche}
%-----------------------------

@D comparison \verb#operator==# of a \Rational\ with a \Digit\
@{inline bool operator==(const Rational& a, const Digit b)
// Algorithm:  c := a == b
// Input:      a in Rational, b in Digit.
// Output:     c in bool such that if a = b then c = true else c = false ||
{
  return (a.numerator() == b && a.denominator() == 1);
}
@| operator== @}

@d comparison \verb#operator!=# of a \Rational\ with a \Digit\
@{inline bool operator!=(const Rational& a, const Digit b)
// Algorithm:  c := a != b
// Input:      a in Rational, b in Digit.
// Output:     c in bool such that if a = b then c = false else c = true ||
{
  return (a.numerator() != b || a.denominator() != 1);
}
@| operator!= @}

@d comparison \verb#operator<# of a \Rational\ with a \Digit\
@{inline bool operator<(const Rational& a, const Digit b)
// Algorithm:  c := a < b
// Input:      a in Rational, b in Digit.
// Output:     c in bool such that if a < b then c = true else c = false ||
{
  return (a.numerator() < a.denominator()*b);
}
@| operator< @}

@d comparison \verb#operator<=# of a \Rational\ with a \Digit\
@{inline bool operator<=(const Rational& a, const Digit b)
// Algorithm:  c := a <= b
// Input:      a in Rational, b in Digit.
// Output:     c in bool such that if a <= b then c = true else c = false ||
{
  return (a.numerator() <= a.denominator()*b);
}
@| operator<= @}

@d comparison \verb#operator># of a \Rational\ with a \Digit\
@{inline bool operator>(const Rational& a, const Digit b)
// Algorithm:  c := a > b
// Input:      a in Rational, b in Digit.
// Output:     c in bool such that if a > b then c = true else c = false ||
{
  return (a.numerator() > a.denominator()*b);
}
@| operator> @}

@d comparison \verb#operator>=# of a \Rational\ with a \Digit\
@{inline bool operator>=(const Rational& a, const Digit b)
// Algorithm:  c := a >= b
// Input:      a in Rational, b in Digit.
// Output:     c in bool such that if a >= b then c = true else c = false ||
{
  return (a.numerator() >= a.denominator()*b);
}
@| operator>= @}


\section{Additive Operationen}
%=============================

\subsection{Inkrementierung}
%---------------------------

@D prefix incrementation of a \Rational\
@{inline const Rational& Rational::operator++()
// Algorithm:  c := ++a
// Input:      a in Rational.
// Output:     a,c in Rational such that a := a+1, c := a ||
{
  num += den;
  return *this;
}
@| Rational::operator++ operator++ @}

@d postfix incrementation of a \Rational\
@{inline Rational Rational::operator++(int)
// Algorithm:  c := a++
// Input:      a in Rational.
// Output:     a,c in Rational such that c := a, a := a+1 ||
{
  Rational a(*this);
  ++(*this);
  return a;
}
@| Rational::operator++ operator++ @}


\subsection{Decrementierung}
%---------------------------

@D prefix decrementation of a \Rational\
@{inline const Rational& Rational::operator--()
// Algorithm:  c := --a
// Input:      a in Rational.
// Output:     a,c in Rational such that a := a-1, c := a ||
{
  num -= den;
  return *this;
}
@| Rational::operator-- operator-- @}

@d postfix decrementation of a \Rational\
@{inline Rational Rational::operator--(int)
// Algorithm:  c := a--
// Input:      a in Rational.
// Output:     a,c in Rational such that c := a, a := a-1 ||
{
  Rational a(*this);
  --(*this);
  return a;
}
@| Rational::operator-- operator-- @}


\subsection{Negation}
%--------------------

@D negation \verb#operator-# of a \Rational\
@{inline Rational::Rational(const binder_arguments<Rational, Rational,
                                                   Rational_negate_tag>& a)
 : num(-a.x.num), den(a.x.den)
{
}

inline Rational& Rational::operator=(const binder_arguments<Rational, Rational,
                                                            Rational_negate_tag>& a)
{
  num = -a.x.num;
  if (this != &a.x) den = a.x.den;
  return *this;
}

inline binder_arguments<Rational, Rational, Rational_negate_tag>
 operator-(const Rational& a)
// Algorithm:  c := -a
// Input:      a in Rational.
// Output:     c in Rational such that c = -a ||
{
  return binder_arguments<Rational, Rational, Rational_negate_tag>(a, a);
}
@| Rational::Rational Rational Rational::operator= operator= operator- @}


\subsection{Addition}
%--------------------

@D addition of two \Rational s
@{void Rational::add(const Rational& a, const Rational& b)
// Algorithm:  c.add(a, b)
// Input:      a,b in Rational.
// Output:     c in Rational such that c = a + b ||
{
  if (sign(a.num) == 0) { num = b.num; den = b.den; }
  else if (sign(b.num) == 0) { num = a.num; den = a.den; }
  else {
    Natural g = gcd(a.den, b.den);
    if (g == 1) {
      @<special case of \Rational\ addition@>
    } else {
      @<general case of \Rational\ addition@>
    }
  }
}
@| Rational::add add @}

\[\frac{\texttt{num}}{\texttt{den}} = \frac{\texttt{a.num}\cdot\texttt{b.den} + \texttt{a.den}\cdot\texttt{b.num}}
       {\texttt{a.den}\cdot\texttt{b.den}} :\]

@d special case of \Rational\ addition
@{const Integer h = a.den * b.num;
num = a.num * b.den;
num += h;
den = a.den * b.den;@}

\begin{eqnarray*}
g &=& \gcd(\texttt{a.den}, \texttt{b.den}),\\
t &=& \texttt{a.num}\cdot\frac{\texttt{b.den}}{g} + \texttt{b.num}\cdot\frac{\texttt{a.den}}{g},\\
h &=& \gcd(t, g),\\
\texttt{num} &=& \frac{t}{h},\\
\texttt{den} &=& \frac{\texttt{a.den}}{g}\cdot\frac{\texttt{b.den}}{h} :
\end{eqnarray*}

@d general case of \Rational\ addition
@{Natural s = b.den / g;
Integer t = a.num * s;
s = a.den / g;
t += b.num * s;
g = gcd(abs(t), g);
num = t / g;
g = b.den / g;
den = s * g;@}


@D additive \verb#operator+# for \Rational s
@{inline Rational::Rational(const binder_arguments<Rational, Rational,
                                                   Rational_plus_tag>& a)
{
  add(a.x, a.y);
}

inline Rational& Rational::operator=(const binder_arguments<Rational, Rational,
                                                            Rational_plus_tag>& a)
{
  add(a.x, a.y);
  return *this;
}

inline binder_arguments<Rational, Rational, Rational_plus_tag>
 operator+(const Rational& a, const Rational& b)
// Algorithm:  c := a+b
// Input:      a,b in Rational.
// Output:     c in Rational such that c = a+b ||
{
  return binder_arguments<Rational, Rational, Rational_plus_tag>(a, b);
}
@| Rational::Rational Rational Rational::operator= operator= operator+ @}


\subsubsection{Zuweisungsoperator}

@D assign \verb#operator+=# for \Rational s
@{inline Rational& Rational::operator+=(const Rational& a)
// Algorithm:  c := c += a
// Input:      a,c in Rational.
// Output:     c in Rational such that c := c+a ||
{
  add(*this, a);
  return *this;
}
@| Rational::operator+= operator+= @}



\subsection{Subtraktion}
%-----------------------

@D subtraction of two \Rational s
@{void Rational::sub(const Rational& a, const Rational& b)
// Algorithm:  c.sub(a, b)
// Input:      a,b in Rational.
// Output:     c in Rational such that c = a - b ||
{
  if (sign(a.num) == 0) { num = -b.num; den = b.den; }
  else if (sign(b.num) == 0) { num = a.num; den = a.den; }
  else {
    Natural g = gcd(a.den, b.den);
    if (g == 1) {
      @<special case of \Rational\ subtraction@>
    } else {
      @<general case of \Rational\ subtraction@>
    }
  }
}
@| Rational::sub sub @}

\[\frac{\texttt{num}}{\texttt{den}} = \frac{\texttt{a.num}\cdot\texttt{b.den} - \texttt{a.den}\cdot\texttt{b.num}}
       {\texttt{a.den}\cdot\texttt{b.den}} :\]

@d special case of \Rational\ subtraction
@{const Integer h = a.den * b.num;
num = a.num * b.den;
num -= h;
den = a.den * b.den;@}


\begin{eqnarray*}
g &=& \gcd(\texttt{a.den}, \texttt{b.den}),\\
t &=& \texttt{a.num}\cdot\frac{\texttt{b.den}}{g} - \texttt{b.num}\cdot\frac{\texttt{a.den}}{g},\\
h &=& \gcd(t, g),\\
\texttt{num} &=& \frac{t}{h},\\
\texttt{den} &=& \frac{\texttt{a.den}}{g}\cdot\frac{\texttt{b.den}}{h} :
\end{eqnarray*}

@d general case of \Rational\ subtraction
@{Natural s = b.den / g;
Integer t = a.num * s;
s = a.den / g;
t -= b.num * s;
g = gcd(abs(t), g);
num = t / g;
g = b.den / g;
den = s * g;@}

@D additive \verb#operator-# for \Rational s
@{inline Rational::Rational(const binder_arguments<Rational, Rational,
                                                   Rational_minus_tag>& a)
{
  sub(a.x, a.y);
}

inline Rational& Rational::operator=(const binder_arguments<Rational, Rational,
                                                            Rational_minus_tag>& a)
{
  sub(a.x, a.y);
  return *this;
}

inline binder_arguments<Rational, Rational, Rational_minus_tag>
 operator-(const Rational& a, const Rational& b)
// Algorithm:  c := a-b
// Input:      a,b in Rational.
// Output:     c in Rational such that c = a-b ||
{
  return binder_arguments<Rational, Rational, Rational_minus_tag>(a, b);
}
@| Rational::Rational Rational Rational::operator= operator= operator- @}


\subsubsection{Zuweisungsoperator}

@D assign \verb#operator-=# for \Rational s
@{inline Rational& Rational::operator-=(const Rational& a)
// Algorithm:  c := c -= a
// Input:      a,c in Rational.
// Output:     c in Rational such that c := c-a ||
{
  sub(*this, a);
  return *this;
}
@| Rational::operator-= operator-= @}



\section{Schiebeoperationen}
%===========================

\subsection{Linksverschiebung}
%-----------------------------

@D multiplication of a \Rational\ by a power of 2
@{/*
template <class I, class N>
void QuotientField<I, N>::lshift(const QuotientField<I, N>& a, size_t b)
// Algorithm:  c.lshift(a, b)
// Input:      a in QuotientField<I, N>, b in size_t.
// Output:     c in QuotientField<I, N> such that c = a * 2^b ||
{
  den = a.den;
  while (b && (den&1) == 0) { --b; den >>= 1; }
  num = a.num << b;
}
*/
@| Rational::lshift lshift @}

@D multiplication of a \Rational\ by a power of 2
@{void Rational::lshift(const Rational& a, size_t b)
// Algorithm:  c.lshift(a, b)
// Input:      a in Rational, b in size_t.
// Output:     c in Rational such that c = a * 2^b ||
{
  size_t i = 0;
  const Natural& c = a.den;
  while (i < b && !c.testbit(i)) ++i;
  den = a.den >> i;
  num = a.num << (b-i);
}
@| Rational::lshift lshift @}

@D shift \verb#operator<<# of a \Rational\
@{inline Rational::Rational(const binder_arguments<Rational, size_t,
                                                   Rational_lshift_tag>& a)
{
  lshift(a.x, a.y);
}

inline Rational& Rational::operator=(const binder_arguments<Rational, size_t,
                                                            Rational_lshift_tag>& a)
{
  lshift(a.x, a.y);
  return *this;
}

inline binder_arguments<Rational, size_t, Rational_lshift_tag>
 operator<<(const Rational& a, const size_t& b)
// Algorithm:  c := a << b
// Input:      a in Rational, b in size_t.
// Output:     c in Rational such that c = a * 2^b ||
{
  return binder_arguments<Rational, size_t, Rational_lshift_tag>(a, b);
}
@| Rational::Rational Rational Rational::operator= operator= operator<< @}


\subsubsection{Zuweisungsoperator}

@D assign \verb#operator<<=# of a \Rational\
@{inline Rational& Rational::operator<<=(const size_t a)
// Algorithm:  c := c <<= a
// Input:      a in size_t, c in Rational.
// Output:     c in Rational such that c := c * 2^a ||
{
  lshift(*this, a);
  return *this;
}
@| Rational::operator<<= operator<<= @}


\subsection{Rechtsverschiebung}
%------------------------------

@D division of a \Rational\ by a power of 2
@{/*
template <class I, class N>
void QuotientField<I, N>::rshift(const QuotientField<I, N>& a, size_t b)
// Algorithm:  c.rshift(a, b)
// Input:      a in QuotientField<I, N>, b in size_t.
// Output:     c in QuotientField<I, N> such that c = a / 2^b ||
{
  num = a.num;
  N& c = abs(num);
  while (b && (c&1) == 0) { --b; c >>= 1; }
  den = a.den << b;
}
*/
@| Rational::rshift rshift @}

@D division of a \Rational\ by a power of 2
@{void Rational::rshift(const Rational& a, size_t b)
// Algorithm:  c.rshift(a, b)
// Input:      a in Rational, b in size_t.
// Output:     c in Rational such that c = a / 2^b ||
{
  size_t i = 0;
  const Natural& c = abs(a.num);
  while (i < b && !c.testbit(i)) ++i;
  num = a.num >> i;
  den = a.den << (b-i);
}
@| Rational::rshift rshift @}


@D shift \verb#operator>># of a \Rational\
@{inline Rational::Rational(const binder_arguments<Rational, size_t,
                                                 Rational_rshift_tag>& a)
{
  rshift(a.x, a.y);
}

inline Rational& Rational::operator=(const binder_arguments<Rational, size_t,
                                                            Rational_rshift_tag>& a)
{
  rshift(a.x, a.y);
  return *this;
}

inline binder_arguments<Rational, size_t, Rational_rshift_tag>
 operator>>(const Rational& a, const size_t& b)
// Algorithm:  c := a >> b
// Input:      a in Rational, b in size_t.
// Output:     c in Rational such that c = a / 2^b ||
{
  return binder_arguments<Rational, size_t, Rational_rshift_tag>(a, b);
}
@| Rational::Rational Rational Rational::operator= operator= operator>> @}


\subsubsection{Zuweisungsoperator}

@d assign \verb#operator>>=# of a \Rational\
@{inline Rational& Rational::operator>>=(const size_t a)
// Algorithm:  c := c >>= a
// Input:      a in size_t, c in Rational.
// Output:     c in Rational such that c := c / 2^a ||
{
  rshift(*this, a);
  return *this;
}
@| Rational::operator>>= operator>>= @}


\section{Multiplikative Operationen}
%===================================

\subsection{Quadratur}
%---------------------

@D squaring of a \Rational\
@{inline void Rational::sqr(const Rational& a)
// Algorithm:  b.sqr(a)
// Input:      a in Rational.
// Output:     b in Rational such that b = a^2 ||
{
  num = a.num*a.num;
  den = a.den*a.den;
}
@| Rational::sqr sqr @}


\subsection{Multiplikation}
%--------------------------

@D multiplication of two \Rational s
@{void Rational::mul(const Rational& a, const Rational& b)
// Algorithm:  c.mul(a, b)
// Input:      a,b in Rational.
// Output:     c in Rational such that c = a * b ||
{
  Natural g = gcd(abs(a.num), b.den);
  Natural h = gcd(a.den, abs(b.num));
  if (g == 1) {
    if (h == 1) {
      @<special case 1 of \Rational\ multiplication@>
    } else {
      @<special case 2 of \Rational\ multiplication@>
    }
  } else if (h == 1) {
    @<special case 3 of \Rational\ multiplication@>
  } else {
    @<general case of \Rational\ multiplication@>
  }
}
@| Rational::mul mul @}


\[\frac{\texttt{num}}{\texttt{den}} = \frac{\texttt{a.num}\cdot\texttt{b.num}}{\texttt{a.den}\cdot\texttt{b.den}} : \]

@d special case 1 of \Rational\ multiplication
@{num = a.num * b.num;
den = a.den * b.den;@}

\begin{eqnarray*}
h &=& \gcd(\texttt{a.den}, \abs(\texttt{b.num})),\\
\frac{\texttt{num}}{\texttt{den}} &=& \frac{\texttt{a.num}\cdot\frac{\texttt{b.num}}{h}}{\frac{\texttt{a.den}}{h}\cdot\texttt{b.den}} :
\end{eqnarray*}

@d special case 2 of \Rational\ multiplication
@{Integer t = b.num / h;
g = a.den / h;
num = a.num * t;
den = g * b.den;@}

\begin{eqnarray*}
g &=& \gcd(\abs(\texttt{a.num}), \texttt{b.den}),\\
\frac{\texttt{num}}{\texttt{den}} &=& \frac{\frac{\texttt{a.num}}{g}\cdot\texttt{b.num}}{\texttt{a.den}\cdot\frac{\texttt{b.den}}{g}} :
\end{eqnarray*}

@d special case 3 of \Rational\ multiplication
@{Integer t = a.num / g;
h = b.den / g;
num = t * b.num;
den = a.den * h;@}

\begin{eqnarray*}
g &=& \gcd(\abs(\texttt{a.num}), \texttt{b.den}),\\
h &=& \gcd(\texttt{a.den}, \abs(\texttt{b.num})),\\
\frac{\texttt{num}}{\texttt{den}} &=& \frac{\frac{\texttt{a.num}}{g}\cdot\frac{\texttt{b.num}}{h}}{\frac{\texttt{a.den}}{h}\cdot\frac{\texttt{b.den}}{g}} :
\end{eqnarray*}

@d general case of \Rational\ multiplication
@{Integer s = a.num / g;
Integer t = b.num / h;
h = a.den / h;
g = b.den / g;
num = s * t;
den = h * g;@}

@D multiplicative \verb#operator*# for \Rational s
@{inline Rational::Rational(const binder_arguments<Rational, Rational,
                                                 Rational_multiplies_tag>& a)
{
  if (&a.x == &a.y) sqr(a.x);
  else mul(a.x, a.y);
}

inline Rational& Rational::operator=(const binder_arguments<Rational, Rational,
                                                            Rational_multiplies_tag>& a)
{
  if (&a.x == &a.y) sqr(a.x);
  else mul(a.x, a.y);
  return *this;
}

inline binder_arguments<Rational, Rational, Rational_multiplies_tag>
 operator*(const Rational& a, const Rational& b)
// Algorithm:  c := a*b
// Input:      a,b in Rational.
// Output:     c in Rational such that c = a*b ||
{
  return binder_arguments<Rational, Rational, Rational_multiplies_tag>(a, b);
}
@| Rational::Rational Rational Rational::operator= operator= operator* @}


\subsubsection{Zuweisungsoperator}

@d assign \verb#operator*=# for \Rational s
@{inline Rational& Rational::operator*=(const Rational& a)
// Algorithm:  c := c *= a
// Input:      a,c in Rational.
// Output:     c in Rational such that c := c*a ||
{
  if (this == &a) sqr(*this);
  else mul(*this, a);
  return *this;
}
@| Rational::operator*= operator*= @}


\subsection{Division}
%--------------------

@D division of two \Rational s
@{void Rational::div(const Rational& a, const Rational& b)
// Algorithm:  c.div(a, b)
// Input:      a,b in Rational where not b = 0.
// Output:     c in Rational such that c = a / b ||
{
  if (b.num == 0) b.num.errmsg(4, "(div)");
  Natural g = gcd(abs(a.num), abs(b.num));
  Natural h = gcd(a.den, b.den);
  if (g == 1) {
    if (h == 1) {
      @<special case 1 of \Rational\ division@>
    } else {
      @<special case 2 of \Rational\ division@>
    }
  } else if (h == 1) {
    @<special case 3 of \Rational\ division@>
  } else {
    @<general case of \Rational\ division@>
  }
}
@| Rational::div div @}

\[\frac{\texttt{num}}{\texttt{den}} = \frac{\texttt{a.num}\cdot\texttt{b.den}\cdot\sign(\texttt{b.num})}
                                           {\texttt{a.den}\cdot\texttt{b.num}\cdot\sign(\texttt{b.num})} :\]

@D special case 1 of \Rational\ division
@{if (this == &b) {
  const bool i = (sign(num) == -1);
  g = a.den * abs(num);
  num = a.num * den;
  den = g;
  if (i) num = -num;
} else {
  num = a.num * b.den;
  den = a.den * abs(b.num);
  if (sign(b.num) == -1) num = -num;
}@}


\begin{eqnarray*}
h &=& \gcd(\texttt{a.den}, \texttt{b.den}),\\
\frac{\texttt{num}}{\texttt{den}} &=& \frac{\texttt{a.num}\cdot\frac{\texttt{b.den}}{h}\cdot\sign(\texttt{b.num})}
                                         {\frac{\texttt{a.den}}{h}\cdot\texttt{b.num}\cdot\sign(\texttt{b.num})} :
\end{eqnarray*}

@D special case 2 of \Rational\ division
@{Natural t = b.den / h;
g = a.den / h;
den = g * abs(b.num);
if (sign(b.num) == -1) {
  num = a.num * t;
  num = -num;
} else num = a.num * t;@}


\begin{eqnarray*}
g &=& \gcd(\abs(\texttt{a.num}), \abs(\texttt{b.num})),\\
\frac{\texttt{num}}{\texttt{den}} &=& \frac{\frac{\texttt{a.num}}{g}\cdot\texttt{b.den}\cdot\sign(\texttt{b.num})}
                                         {\texttt{a.den}\cdot\frac{\texttt{b.num}}{g}\cdot\sign(\texttt{b.num})} :
\end{eqnarray*}

@D special case 3 of \Rational\ division
@{Integer t = a.num / g;
Integer s = b.num / g;
num = t * b.den;
den = a.den * abs(s);
if (sign(s) == -1) num = -num;@}

\begin{eqnarray*}
g &=& \gcd(\abs(\texttt{a.num}), \abs(\texttt{b.num})),\\
h &=& \gcd(\texttt{a.den}, \texttt{b.den}),\\
\frac{\texttt{num}}{\texttt{den}} &=& \frac{\frac{\texttt{a.num}}{g}\cdot\frac{\texttt{b.den}}{h}\cdot\sign(\texttt{b.num})}
                                         {\frac{\texttt{a.den}}{h}\cdot\frac{\texttt{b.num}}{g}\cdot\sign(\texttt{b.num})} :
\end{eqnarray*}

@D general case of \Rational\ division
@{Integer s = a.num / g;
Natural t = b.den / h;
Integer r = b.num / g;
num = s * t;
t = a.den / h;
den = t * abs(r);
if (sign(r) == -1) num = -num;@}


@D multiplicative \verb#operator/# for \Rational s
@{inline Rational::Rational(const binder_arguments<Rational, Rational,
                                                 Rational_divides_tag>& a)
{
  div(a.x, a.y);
}

inline Rational& Rational::operator=(const binder_arguments<Rational, Rational,
                                                            Rational_divides_tag>& a)
{
  div(a.x, a.y);
  return *this;
}

inline binder_arguments<Rational, Rational, Rational_divides_tag>
 operator/(const Rational& a, const Rational& b)
// Algorithm:  c := a/b
// Input:      a,b in Rational.
// Output:     c in Rational such that c = a/b ||
{
  return binder_arguments<Rational, Rational, Rational_divides_tag>(a, b);
}
@| Rational::Rational Rational Rational::operator= operator= operator/ @}


\subsubsection{Zuweisungsoperator}

@D assign \verb#operator/=# for \Rational s
@{inline Rational& Rational::operator/=(const Rational& a)
// Algorithm:  c := c /= a
// Input:      a,c in Rational where not a = 0.
// Output:     c in Rational such that c := c/a ||
{
  div(*this, a);
  return *this;
}
@| Rational::operator/= operator/= @}



\subsection{Inversion}
%---------------------

@D inversion of a \Rational\
@{Rational inv(const Rational& a)
// Algorithm:  b := inv(a)
// Input:      a in Rational where not a = 0.
// Output:     b in Rational such that b = a^(-1) ||
{
  if (a.num == 0) a.num.errmsg(4, "(inv)");
  Rational b(a.den, abs(a.num));
  if (sign(a.num) == -1) b.num = -b.num;
  return b;
}
@| inv @}



\section{Potenzieren}
%====================

@d power of a \Rational\ by a \Digit\
@{inline Rational pow(const Rational& a, const Digit b)
// Algorithm:  c := pow(a, b)
// Input:      a in Rational, b in Digit.
// Output:     c in Rational such that c = a^b ||
{
  return Rational(pow(a.numerator(), b), pow(a.denominator(), b));
}
@| pow @}

@D power of a \Rational\ by an \Integer\
@{Rational pow(const Rational& a, const Integer& b)
// Algorithm:  c := pow(a, b)
// Input:      a in Rational, b in Integer.
// Output:     c in Rational such that c = a^b ||
{
  if (sign(b) >= 0) return Rational(pow(a.numerator(), b), pow(a.denominator(), abs(b)));
  else {
    const Natural& c = abs(b);
    return Rational(pow(a.numerator(), Integer(c)), pow(a.denominator(), c));
  }
}
@| pow @}



\section{Rundungsfunktionen}
%===========================

@D function \verb#ceil# of a \Rational\
@{Integer ceil(const Rational& a)
// Algorithm:  c := ceil(a)
// Input:      a in Rational.
// Output:     c in Integer such that c = min{x in Integer | x >= a} ||
{
  if (a == 0) return Digit(0);
  Natural q,r;
  div(abs(a.numerator()), a.denominator(), q, r);
  if (sign(a) == -1) return -Integer(q);
  r <<= 1;
  if (r >= q) ++q;
  return q;
}
@| ceil @}

@D function \verb#floor# of a \Rational\
@{Integer floor(const Rational& a)
// Algorithm:  c := floor(a)
// Input:      a in Rational.
// Output:     c in Integer such that c = max{x in Integer | x <= a} ||
{
  Natural q,r;
  div(abs(a.numerator()), a.denominator(), q, r);
  Integer t = q;
  if (sign(a) == -1) {
    t = -t;
    if (r != 0) --t;
  }
  return t;
}
@| floor @}

@d function \verb#round# of a \Rational\
@{inline Integer round(const Rational& a)
// Algorithm:  c := round(a)
// Input:      a in Rational.
// Output:     c in Integer such that c = floor(a+1/2) ||
{
  return floor(a + Rational(1, 2));
}
@| round @}

@D function \verb#trunc# of a \Rational\
@{Integer trunc(const Rational& a)
// Algorithm:  c := trunc(a)
// Input:      a in Rational.
// Output:     c in Integer such that c = sign(a)*[|a|] ||
{
  Natural q,r;
  div(abs(a.numerator()), a.denominator(), q, r);
  if (sign(a) == -1) return -Integer(q);
  return q;
}
@| trunc @}



\section{Zufallszahl}
%====================

@D calculates a \Rational\ random number
@{inline void Rational::rand(const size_t n)
// Algorithm:  a.rand(n)
// Input:      n in size_t.
// Output:     a in Rational
//             such that |a_1| < 2^n, a_2 <= 2^n where a_1/a_2 = a (random number) ||
{
  num.rand(n);
  den.rand(n); ++den;
  const Natural t = gcd(abs(num), den);
  num /= t; den /= t;
}
@| Rational::rand rand @}

