///////////////////////////////
//
// Piologie V1.2.1
// multi-precision arithmetic
// Pi-Calculation
//
// Sebastian Wedeniwski
// 03/18/1998
//


#ifndef _Include_Pi_H_
#define _Include_Pi_H_

#include "integer.h"

class Fixed : private Natural {
private:
  const size_t prec,dec;

public:
  Fixed(const size_t);
  Fixed(const Fixed&);

  void      output(ostream&);
  size_t    precision() const;
  size_t    decimals() const;
  Natural&  value() const;
};


inline ostream& operator<<(ostream&, Fixed);

class Pi {
private:
  Fixed pi;

  void stoermer(const size_t, Natural&);
  void schoenhage(const size_t, Natural&);
  void chudnovsky(size_t, const size_t, Integer&, Integer&, Integer&) const;
  void chudnovsky2(const size_t, const size_t, Integer&, Integer&) const;

public:
  Pi(const size_t);

  inline friend ostream& operator<<(ostream&, const Pi&);
};

class Zeta3 {
private:
  Fixed zeta;

  void linear(const size_t, Natural&) const;
  void series(size_t, const size_t, Integer&, Integer&, Integer&) const;
  void series2(const size_t, const size_t, Integer&, Integer&) const;

public:
  Zeta3(const size_t);

  inline friend ostream& operator<<(ostream&, const Zeta3&);
};

/////////////////// Inline-Implementation ///////////////////////

inline Natural& Fixed::value() const
{
  return (Natural&)*this;
}

inline Fixed::Fixed(const size_t n)
 : prec(NumberOfDecimals(n+ALPHA_WIDTH)), dec(n)
{
  RestoreSize();
}

inline Fixed::Fixed(const Fixed& a)
 : Natural(a.value()), prec(a.prec), dec(a.dec)
{
}

inline size_t Fixed::precision() const
{
  return prec;
}

inline size_t Fixed::decimals() const
{
  return dec;
}

inline ostream& operator<<(ostream& out, Fixed a)
// Algorithm:  o := operator<<(o, a)
// Input:      o in ostream, a in Fixed.
// Output:     o in ostream ||
//
// Note:       puts Fixed a on output stream.
{
  a.output(out);
  return out;
}

inline ostream& operator<<(ostream& out, const Pi& a)
// Algorithm:  o := o << a
// Input:      o in ostream, a in Pi.
// Output:     o in ostream ||
//
// Note:       puts Pi a on output stream.
{
  return out << a.pi;
}

inline ostream& operator<<(ostream& out, const Zeta3& a)
// Algorithm:  o := o << a
// Input:      o in ostream, a in Zeta3.
// Output:     o in ostream ||
//
// Note:       puts Zeta3 a on output stream.
{
  return out << a.zeta;
}


#endif
